/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.schema;

import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.schema.DataSourceType;
import com.google.gerrit.server.schema.ScriptRunner;
import java.io.IOException;
import java.io.InputStream;

public abstract class BaseDataSourceType
implements DataSourceType {
    private final String driver;

    protected BaseDataSourceType(String driver) {
        this.driver = driver;
    }

    @Override
    public final String getDriver() {
        return this.driver;
    }

    @Override
    public boolean usePool() {
        return true;
    }

    @Override
    public ScriptRunner getIndexScript() throws IOException {
        return BaseDataSourceType.getScriptRunner("index_generic.sql");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final ScriptRunner getScriptRunner(String path) throws IOException {
        ScriptRunner runner;
        if (path == null) {
            return ScriptRunner.NOOP;
        }
        InputStream in = ReviewDb.class.getResourceAsStream(path);
        if (in == null) {
            throw new IllegalStateException("SQL script " + path + " not found");
        }
        try {
            runner = new ScriptRunner(path, in);
        }
        finally {
            in.close();
        }
        return runner;
    }
}

