/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.schema;

import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.config.SitePaths;
import com.google.gerrit.server.schema.BaseDataSourceType;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import org.eclipse.jgit.lib.Config;

class H2
extends BaseDataSourceType {
    protected final Config cfg;
    private final SitePaths site;

    @Inject
    H2(SitePaths site, @GerritServerConfig Config cfg) {
        super("org.h2.Driver");
        this.cfg = cfg;
        this.site = site;
    }

    @Override
    public String getUrl() {
        String database = this.cfg.getString("database", null, "database");
        if (database == null || database.isEmpty()) {
            database = "db/ReviewDB";
        }
        File db = this.site.resolve(database);
        try {
            db = db.getCanonicalFile();
        }
        catch (IOException e) {
            db = db.getAbsoluteFile();
        }
        return "jdbc:h2:" + db.toURI().toString();
    }
}

