/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.schema;

import com.google.gerrit.server.config.ConfigSection;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.schema.BaseDataSourceType;
import com.google.gerrit.server.schema.JdbcUtil;
import com.google.inject.Inject;
import org.eclipse.jgit.lib.Config;

class MySql
extends BaseDataSourceType {
    private Config cfg;

    @Inject
    public MySql(@GerritServerConfig Config cfg) {
        super("com.mysql.jdbc.Driver");
        this.cfg = cfg;
    }

    @Override
    public String getUrl() {
        StringBuilder b = new StringBuilder();
        ConfigSection dbs = new ConfigSection(this.cfg, "database");
        b.append("jdbc:mysql://");
        b.append(JdbcUtil.hostname(dbs.optional("hostname")));
        b.append(JdbcUtil.port(dbs.optional("port")));
        b.append("/");
        b.append(dbs.required("database"));
        return b.toString();
    }

    @Override
    public boolean usePool() {
        return false;
    }
}

