/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.schema;

import com.google.common.collect.Lists;
import com.google.gerrit.reviewdb.client.CurrentSchemaVersion;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.schema.Current;
import com.google.gerrit.server.schema.Schema_93;
import com.google.gerrit.server.schema.UpdateUI;
import com.google.gwtorm.jdbc.JdbcExecutor;
import com.google.gwtorm.jdbc.JdbcSchema;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.StatementExecutor;
import com.google.inject.AbstractModule;
import com.google.inject.Provider;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class SchemaVersion {
    public static final Class<Schema_93> C = Schema_93.class;
    private final Provider<? extends SchemaVersion> prior;
    private final int versionNbr;

    protected SchemaVersion(Provider<? extends SchemaVersion> prior) {
        this.prior = prior;
        this.versionNbr = SchemaVersion.guessVersion(this.getClass());
    }

    public static int guessVersion(Class<?> c) {
        String n = c.getName();
        n = n.substring(n.lastIndexOf(95) + 1);
        while (n.startsWith("0")) {
            n = n.substring(1);
        }
        return Integer.parseInt(n);
    }

    protected SchemaVersion(Provider<? extends SchemaVersion> prior, int versionNbr) {
        this.prior = prior;
        this.versionNbr = versionNbr;
    }

    public final int getVersionNbr() {
        return this.versionNbr;
    }

    public final void check(UpdateUI ui, CurrentSchemaVersion curr, ReviewDb db) throws OrmException, SQLException {
        if (curr.versionNbr != this.versionNbr) {
            if (curr.versionNbr > this.versionNbr) {
                throw new OrmException("Cannot downgrade database schema from version " + curr.versionNbr + " to " + this.versionNbr + ".");
            }
            this.upgradeFrom(ui, curr, db);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradeFrom(UpdateUI ui, CurrentSchemaVersion curr, ReviewDb db) throws OrmException, SQLException {
        List<SchemaVersion> pending = this.pending(curr.versionNbr);
        this.updateSchema(pending, ui, db);
        this.migrateData(pending, ui, curr, db);
        JdbcSchema s = (JdbcSchema)((Object)db);
        try (JdbcExecutor e = new JdbcExecutor(s);){
            final ArrayList<String> pruneList = Lists.newArrayList();
            s.pruneSchema(new StatementExecutor(){

                @Override
                public void execute(String sql) {
                    pruneList.add(sql);
                }
            });
            if (!pruneList.isEmpty()) {
                ui.pruneSchema(e, pruneList);
            }
        }
    }

    private List<SchemaVersion> pending(int curr) {
        ArrayList<SchemaVersion> r = Lists.newArrayListWithCapacity(this.versionNbr - curr);
        SchemaVersion v = this;
        while (curr < v.getVersionNbr()) {
            r.add(v);
            v = v.prior.get();
        }
        Collections.reverse(r);
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSchema(List<SchemaVersion> pending, UpdateUI ui, ReviewDb db) throws OrmException, SQLException {
        for (SchemaVersion v : pending) {
            ui.message(String.format("Upgrading schema to %d ...", v.getVersionNbr()));
            v.preUpdateSchema(db);
        }
        JdbcSchema s = (JdbcSchema)((Object)db);
        try (JdbcExecutor e = new JdbcExecutor(s);){
            s.updateSchema(e);
        }
    }

    protected void preUpdateSchema(ReviewDb db) throws OrmException, SQLException {
    }

    private void migrateData(List<SchemaVersion> pending, UpdateUI ui, CurrentSchemaVersion curr, ReviewDb db) throws OrmException, SQLException {
        for (SchemaVersion v : pending) {
            ui.message(String.format("Migrating data to schema %d ...", v.getVersionNbr()));
            v.migrateData(db, ui);
            v.finish(curr, db);
        }
    }

    protected void migrateData(ReviewDb db, UpdateUI ui) throws OrmException, SQLException {
    }

    protected void finish(CurrentSchemaVersion curr, ReviewDb db) throws OrmException {
        curr.versionNbr = this.versionNbr;
        db.schemaVersion().update(Collections.singleton(curr));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renameTable(ReviewDb db, String from, String to) throws OrmException {
        JdbcSchema s = (JdbcSchema)((Object)db);
        try (JdbcExecutor e = new JdbcExecutor(s);){
            s.renameTable(e, from, to);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renameColumn(ReviewDb db, String table, String from, String to) throws OrmException {
        JdbcSchema s = (JdbcSchema)((Object)db);
        try (JdbcExecutor e = new JdbcExecutor(s);){
            s.renameField(e, table, from, to);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(ReviewDb db, String sql) throws SQLException {
        try (Statement s = ((JdbcSchema)((Object)db)).getConnection().createStatement();){
            s.execute(sql);
        }
    }

    public static class Module
    extends AbstractModule {
        @Override
        protected void configure() {
            this.bind(SchemaVersion.class).annotatedWith(Current.class).to(C);
        }
    }
}

