/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.schema;

import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.client.SystemConfig;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.LocalDiskRepositoryManager;
import com.google.gerrit.server.schema.SchemaVersion;
import com.google.gerrit.server.schema.Schema_54;
import com.google.gerrit.server.schema.UpdateUI;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.File;
import java.util.Collections;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.util.FS;

public class Schema_55
extends SchemaVersion {
    private final GitRepositoryManager mgr;

    @Inject
    Schema_55(Provider<Schema_54> prior, GitRepositoryManager mgr) {
        super(prior);
        this.mgr = mgr;
    }

    @Override
    protected void migrateData(ReviewDb db, UpdateUI ui) throws OrmException {
        SystemConfig sc = db.systemConfig().get(new SystemConfig.Key());
        String oldName = sc.wildProjectName.get();
        String newName = "All-Projects";
        if ("-- All Projects --".equals(oldName)) {
            ui.message("Renaming \"" + oldName + "\" to \"" + newName + "\"");
            File base = ((LocalDiskRepositoryManager)this.mgr).getBasePath();
            File oldDir = RepositoryCache.FileKey.resolve(new File(base, oldName), FS.DETECTED);
            File newDir = new File(base, newName + ".git");
            if (!oldDir.renameTo(newDir)) {
                throw new OrmException("Cannot rename " + oldDir.getAbsolutePath() + " to " + newDir.getAbsolutePath());
            }
            sc.wildProjectName = new Project.NameKey(newName);
            db.systemConfig().update(Collections.singleton(sc));
        }
    }
}

