/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.schema;

import com.google.gerrit.common.data.AccessSection;
import com.google.gerrit.common.data.PermissionRule;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.client.AccountGroupName;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.client.SystemConfig;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.GerritPersonIdent;
import com.google.gerrit.server.config.SitePaths;
import com.google.gerrit.server.extensions.events.GitReferenceUpdated;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.MetaDataUpdate;
import com.google.gerrit.server.git.ProjectConfig;
import com.google.gerrit.server.schema.SchemaVersion;
import com.google.gerrit.server.schema.Schema_56;
import com.google.gerrit.server.schema.UpdateUI;
import com.google.gwtorm.jdbc.JdbcSchema;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Collections;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.util.FS;

public class Schema_57
extends SchemaVersion {
    private final SitePaths site;
    private final GitRepositoryManager mgr;
    private final PersonIdent serverUser;

    @Inject
    Schema_57(Provider<Schema_56> prior, SitePaths site, GitRepositoryManager mgr, @GerritPersonIdent PersonIdent serverUser) {
        super(prior);
        this.site = site;
        this.mgr = mgr;
        this.serverUser = serverUser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void migrateData(ReviewDb db, UpdateUI ui) throws OrmException {
        SystemConfig sc = db.systemConfig().get(new SystemConfig.Key());
        Project.NameKey allProjects = sc.wildProjectName;
        FileBasedConfig cfg = new FileBasedConfig(this.site.gerrit_config, FS.DETECTED);
        boolean cfgDirty = false;
        try {
            cfg.load();
        }
        catch (ConfigInvalidException err) {
            throw new OrmException("Cannot read " + this.site.gerrit_config, err);
        }
        catch (IOException err) {
            throw new OrmException("Cannot read " + this.site.gerrit_config, err);
        }
        if (!allProjects.get().equals("All-Projects")) {
            ui.message("Setting gerrit.allProjects = " + allProjects.get());
            cfg.setString("gerrit", null, "allProjects", allProjects.get());
            cfgDirty = true;
        }
        try (Repository git = this.mgr.openRepository(allProjects);){
            AccountGroup batch;
            MetaDataUpdate md = new MetaDataUpdate(GitReferenceUpdated.DISABLED, allProjects, git);
            md.getCommitBuilder().setAuthor(this.serverUser);
            md.getCommitBuilder().setCommitter(this.serverUser);
            ProjectConfig config = ProjectConfig.read(md);
            AccessSection cap = config.getAccessSection("GLOBAL_CAPABILITIES", true);
            cap.getPermission("administrateServer", true).add(new PermissionRule(config.resolve(db.accountGroups().get(sc.adminGroupId))));
            String[] createGroupList = cfg.getStringList("repository", "*", "createGroup");
            boolean isAccountGroupEmpty = false;
            try (PreparedStatement stmt = ((JdbcSchema)((Object)db)).getConnection().prepareStatement("SELECT COUNT(1) FROM account_group_includes WHERE group_id = ?");){
                stmt.setInt(1, sc.batchUsersGroupId.get());
                ResultSet rs = stmt.executeQuery();
                if (rs.next()) {
                    isAccountGroupEmpty = rs.getInt(1) == 0;
                }
            }
            for (String name : createGroupList) {
                AccountGroup group;
                AccountGroup.NameKey key = new AccountGroup.NameKey(name);
                AccountGroupName groupName = db.accountGroupNames().get(key);
                if (groupName == null || (group = db.accountGroups().get(groupName.getId())) == null) continue;
                cap.getPermission("createProject", true).add(new PermissionRule(config.resolve(group)));
            }
            if (createGroupList.length != 0) {
                ui.message("Moved repository.*.createGroup to 'Create Project' capability");
                cfg.unset("repository", "*", "createGroup");
                cfgDirty = true;
            }
            if ((batch = db.accountGroups().get(sc.batchUsersGroupId)) != null && db.accountGroupMembers().byGroup(sc.batchUsersGroupId).toList().isEmpty() && !isAccountGroupEmpty) {
                db.accountGroups().delete(Collections.singleton(batch));
                AccountGroupName name = db.accountGroupNames().get(batch.getNameKey());
                if (name != null) {
                    db.accountGroupNames().delete(Collections.singleton(name));
                }
            } else if (batch != null) {
                cap.getPermission("priority", true).getRule(config.resolve(batch), true).setAction(PermissionRule.Action.BATCH);
            }
            md.setMessage("Upgrade to Gerrit Code Review schema 57\n");
            config.commit(md);
        }
        catch (ConfigInvalidException err) {
            throw new OrmException("Cannot read " + allProjects, err);
        }
        catch (IOException err) {
            throw new OrmException("Cannot update " + allProjects, err);
        }
        if (cfgDirty) {
            try {
                cfg.save();
            }
            catch (IOException err) {
                throw new OrmException("Cannot update " + this.site.gerrit_config, err);
            }
        }
        sc.adminGroupId = new AccountGroup.Id(0);
        sc.adminGroupUUID = new AccountGroup.UUID("DELETED");
        sc.anonymousGroupId = new AccountGroup.Id(0);
        sc.registeredGroupId = new AccountGroup.Id(0);
        sc.wildProjectName = new Project.NameKey("DELETED");
        sc.ownerGroupId = new AccountGroup.Id(0);
        sc.batchUsersGroupId = new AccountGroup.Id(0);
        sc.batchUsersGroupUUID = new AccountGroup.UUID("DELETED");
        sc.registerEmailPrivateKey = "DELETED";
        db.systemConfig().update(Collections.singleton(sc));
    }
}

