/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.schema;

import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.ChangeMessage;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.schema.SchemaVersion;
import com.google.gerrit.server.schema.Schema_59;
import com.google.gerrit.server.schema.UpdateUI;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.ResultSet;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Schema_60
extends SchemaVersion {
    @Inject
    Schema_60(Provider<Schema_59> prior) {
        super(prior);
    }

    @Override
    protected void migrateData(ReviewDb db, UpdateUI ui) throws OrmException {
        Pattern patternA = Pattern.compile("Patch Set ([0-9]+):.*", 32);
        Pattern patternB = Pattern.compile("Uploaded patch set ([0-9]+).");
        ResultSet<ChangeMessage> results = db.changeMessages().all();
        LinkedList<ChangeMessage> updates = new LinkedList<ChangeMessage>();
        for (ChangeMessage cm : results) {
            int patchSetNum;
            Change.Id id = cm.getKey().getParentKey();
            String msg = cm.getMessage();
            Matcher matcherA = patternA.matcher(msg);
            Matcher matcherB = patternB.matcher(msg);
            PatchSet.Id newId = null;
            if (matcherA.matches()) {
                patchSetNum = Integer.parseInt(matcherA.group(1));
                newId = new PatchSet.Id(id, patchSetNum);
            } else if (matcherB.matches()) {
                patchSetNum = Integer.parseInt(matcherB.group(1));
                newId = new PatchSet.Id(id, patchSetNum);
            }
            if (newId != null) {
                cm.setPatchSetId(newId);
                updates.add(cm);
            }
            if (updates.size() < 100) continue;
            db.changeMessages().update(updates);
            updates.clear();
        }
        if (!updates.isEmpty()) {
            db.changeMessages().update(updates);
        }
    }
}

