/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.schema;

import com.google.common.collect.Lists;
import com.google.gerrit.common.data.AccessSection;
import com.google.gerrit.common.data.GroupReference;
import com.google.gerrit.common.data.Permission;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.GerritPersonIdent;
import com.google.gerrit.server.config.AllProjectsName;
import com.google.gerrit.server.extensions.events.GitReferenceUpdated;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.MetaDataUpdate;
import com.google.gerrit.server.git.ProjectConfig;
import com.google.gerrit.server.schema.SchemaVersion;
import com.google.gerrit.server.schema.Schema_63;
import com.google.gerrit.server.schema.UpdateUI;
import com.google.gwtorm.jdbc.JdbcSchema;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;

public class Schema_64
extends SchemaVersion {
    private final AllProjectsName allProjects;
    private final GitRepositoryManager mgr;
    private final PersonIdent serverUser;

    @Inject
    Schema_64(Provider<Schema_63> prior, AllProjectsName allProjects, GitRepositoryManager mgr, @GerritPersonIdent PersonIdent serverUser) {
        super(prior);
        this.allProjects = allProjects;
        this.mgr = mgr;
        this.serverUser = serverUser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void migrateData(ReviewDb db, UpdateUI ui) throws OrmException, SQLException {
        Repository git;
        ArrayList<GroupReference> groups = Lists.newArrayList();
        try (Statement stmt = ((JdbcSchema)((Object)db)).getConnection().createStatement();
             ResultSet rs = stmt.executeQuery("SELECT group_uuid, name FROM account_groups WHERE email_only_authors = 'Y'");){
            while (rs.next()) {
                AccountGroup.UUID uuid = new AccountGroup.UUID(rs.getString(1));
                GroupReference group = new GroupReference(uuid, rs.getString(2));
                groups.add(group);
            }
        }
        if (groups.isEmpty()) {
            return;
        }
        ui.message("Moved account_groups.email_only_authors to 'Email Reviewers' capability");
        try {
            git = this.mgr.openRepository(this.allProjects);
        }
        catch (IOException e) {
            throw new OrmException(e);
        }
        try {
            MetaDataUpdate md = new MetaDataUpdate(GitReferenceUpdated.DISABLED, this.allProjects, git);
            md.getCommitBuilder().setAuthor(this.serverUser);
            md.getCommitBuilder().setCommitter(this.serverUser);
            ProjectConfig config = ProjectConfig.read(md);
            AccessSection section = config.getAccessSection("GLOBAL_CAPABILITIES", true);
            Permission capability = section.getPermission("emailReviewers", true);
            for (GroupReference group : groups) {
                capability.getRule(config.resolve(group), true).setDeny();
            }
            md.setMessage("Upgrade to Gerrit Code Review schema 64\n");
            config.commit(md);
        }
        catch (IOException e) {
            throw new OrmException(e);
        }
        catch (ConfigInvalidException e) {
            throw new OrmException(e);
        }
        finally {
            git.close();
        }
    }
}

