/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.schema;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gerrit.common.data.ContributorAgreement;
import com.google.gerrit.common.data.GroupReference;
import com.google.gerrit.common.data.PermissionRule;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.client.AccountGroupMember;
import com.google.gerrit.reviewdb.client.AccountGroupMemberAudit;
import com.google.gerrit.reviewdb.client.AccountGroupName;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.GerritPersonIdent;
import com.google.gerrit.server.account.GroupUUID;
import com.google.gerrit.server.config.AllProjectsName;
import com.google.gerrit.server.config.AnonymousCowardName;
import com.google.gerrit.server.extensions.events.GitReferenceUpdated;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.MetaDataUpdate;
import com.google.gerrit.server.git.ProjectConfig;
import com.google.gerrit.server.git.VersionedMetaData;
import com.google.gerrit.server.schema.SchemaVersion;
import com.google.gerrit.server.schema.Schema_64;
import com.google.gerrit.server.schema.UpdateUI;
import com.google.gerrit.server.util.TimeUtil;
import com.google.gwtorm.jdbc.JdbcSchema;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.util.SystemReader;

public class Schema_65
extends SchemaVersion {
    private final AllProjectsName allProjects;
    private final GitRepositoryManager mgr;
    private final PersonIdent serverUser;
    @AnonymousCowardName
    private final String anonymousCowardName;

    @Inject
    Schema_65(Provider<Schema_64> prior, AllProjectsName allProjects, GitRepositoryManager mgr, @GerritPersonIdent PersonIdent serverUser, @AnonymousCowardName String anonymousCowardName) {
        super(prior);
        this.allProjects = allProjects;
        this.mgr = mgr;
        this.serverUser = serverUser;
        this.anonymousCowardName = anonymousCowardName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void migrateData(ReviewDb db, UpdateUI ui) throws OrmException, SQLException {
        Repository git;
        try {
            git = this.mgr.openRepository(this.allProjects);
        }
        catch (IOException e) {
            throw new OrmException(e);
        }
        try {
            MetaDataUpdate md = new MetaDataUpdate(GitReferenceUpdated.DISABLED, this.allProjects, git);
            ProjectConfig config = ProjectConfig.read(md);
            Map<Integer, ContributorAgreement> agreements = this.getAgreementToAdd(db, config);
            if (agreements.isEmpty()) {
                return;
            }
            ui.message("Moved contributor agreements to project.config");
            List<AccountGroup.UUID> adminGroupUUIDs = this.getAdministrateServerGroups(db, config);
            for (ContributorAgreement agreement : agreements.values()) {
                if (agreement.getAutoVerify() == null) continue;
                this.getOrCreateGroupForIndividuals(db, config, adminGroupUUIDs, agreement);
            }
            long minTime = this.addAccountAgreements(db, config, adminGroupUUIDs, agreements);
            ProjectConfig base = ProjectConfig.read(md, null);
            for (ContributorAgreement agreement : agreements.values()) {
                base.replace(agreement);
            }
            base.getAccountsSection().setSameGroupVisibility(config.getAccountsSection().getSameGroupVisibility());
            try (VersionedMetaData.BatchMetaDataUpdate batch = base.openUpdate(md);){
                List<AccountGroupAgreement> groupAgreements = this.getAccountGroupAgreements(db, agreements);
                for (AccountGroupAgreement aga : groupAgreements) {
                    minTime = Math.min(minTime, aga.getTime());
                }
                CommitBuilder commit = new CommitBuilder();
                commit.setAuthor(new PersonIdent(this.serverUser, new Date(minTime -= 60000L)));
                commit.setCommitter(new PersonIdent(this.serverUser, new Date(minTime)));
                commit.setMessage("Add the ContributorAgreements for upgrade to Gerrit Code Review schema 65\n");
                batch.write(commit);
                for (AccountGroupAgreement aga : groupAgreements) {
                    Account ua;
                    AccountGroup group = db.accountGroups().get(aga.groupId);
                    if (group == null) continue;
                    ContributorAgreement agreement = agreements.get(aga.claId);
                    agreement.getAccepted().add(new PermissionRule(config.resolve(group)));
                    base.replace(agreement);
                    PersonIdent ident = null;
                    if (aga.reviewedBy != null && (ua = db.accounts().get(aga.reviewedBy)) != null) {
                        String name = ua.getFullName();
                        String email = ua.getPreferredEmail();
                        if (email == null || email.isEmpty()) {
                            String user = ua.getUserName();
                            if (user == null || user.isEmpty()) {
                                user = "account-" + ua.getId().toString();
                            }
                            String host = SystemReader.getInstance().getHostname();
                            email = user + "@" + host;
                        }
                        if (name == null || name.isEmpty()) {
                            int at = email.indexOf(64);
                            name = 0 < at ? email.substring(0, at) : this.anonymousCowardName;
                        }
                        ident = new PersonIdent(name, email, new Date(aga.getTime()), TimeZone.getDefault());
                    }
                    if (ident == null) {
                        ident = new PersonIdent(this.serverUser, new Date(aga.getTime()));
                    }
                    commit = new CommitBuilder();
                    commit.setAuthor(ident);
                    commit.setCommitter(new PersonIdent(this.serverUser, new Date(aga.getTime())));
                    String msg = String.format("Accept %s contributor agreement for %s\n", agreement.getName(), group.getName());
                    if (!Strings.isNullOrEmpty(aga.reviewComments)) {
                        msg = msg + "\n" + aga.reviewComments + "\n";
                    }
                    commit.setMessage(msg);
                    batch.write(commit);
                }
                commit = new CommitBuilder();
                commit.setAuthor(this.serverUser);
                commit.setCommitter(this.serverUser);
                commit.setMessage("Upgrade to Gerrit Code Review schema 65\n");
                commit.addParentId(config.getRevision());
                batch.write(config, commit);
                batch.commitAt(config.getRevision());
            }
        }
        catch (IOException e) {
            throw new OrmException(e);
        }
        catch (ConfigInvalidException e) {
            throw new OrmException(e);
        }
        finally {
            git.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Integer, ContributorAgreement> getAgreementToAdd(ReviewDb db, ProjectConfig config) throws SQLException {
        try (Statement stmt = ((JdbcSchema)((Object)db)).getConnection().createStatement();){
            HashMap<Integer, ContributorAgreement> hashMap;
            ResultSet rs = stmt.executeQuery("SELECT short_name, id, require_contact_information,       short_description, agreement_url, auto_verify FROM contributor_agreements WHERE active = 'Y'");
            try {
                HashMap<Integer, ContributorAgreement> agreements = Maps.newHashMap();
                while (rs.next()) {
                    String name = rs.getString(1);
                    if (config.getContributorAgreement(name) != null) continue;
                    ContributorAgreement a = config.getContributorAgreement(name, true);
                    agreements.put(rs.getInt(2), a);
                    a.setRequireContactInformation("Y".equals(rs.getString(3)));
                    a.setDescription(rs.getString(4));
                    a.setAgreementUrl(rs.getString(5));
                    if (!"Y".equals(rs.getString(6))) continue;
                    a.setAutoVerify(new GroupReference(null, null));
                }
                hashMap = agreements;
            }
            catch (Throwable throwable) {
                rs.close();
                throw throwable;
            }
            rs.close();
            return hashMap;
        }
    }

    private AccountGroup createGroup(ReviewDb db, String groupName, AccountGroup.UUID adminGroupUUID, String description) throws OrmException {
        AccountGroup.Id groupId = new AccountGroup.Id(db.nextAccountGroupId());
        AccountGroup.NameKey nameKey = new AccountGroup.NameKey(groupName);
        AccountGroup.UUID uuid = GroupUUID.make(groupName, this.serverUser);
        AccountGroup group = new AccountGroup(nameKey, groupId, uuid);
        group.setOwnerGroupUUID(adminGroupUUID);
        group.setDescription(description);
        AccountGroupName gn = new AccountGroupName(group);
        db.accountGroupNames().insert(Collections.singleton(gn));
        db.accountGroups().insert(Collections.singleton(group));
        return group;
    }

    private List<AccountGroup.UUID> getAdministrateServerGroups(ReviewDb db, ProjectConfig cfg) {
        List<PermissionRule> rules = cfg.getAccessSection("GLOBAL_CAPABILITIES").getPermission("administrateServer").getRules();
        ArrayList<AccountGroup.UUID> groups = Lists.newArrayListWithExpectedSize(rules.size());
        for (PermissionRule rule : rules) {
            if (rule.getAction() != PermissionRule.Action.ALLOW) continue;
            groups.add(rule.getGroup().getUUID());
        }
        if (groups.isEmpty()) {
            throw new IllegalStateException("no administrator group found");
        }
        return groups;
    }

    private GroupReference getOrCreateGroupForIndividuals(ReviewDb db, ProjectConfig config, List<AccountGroup.UUID> adminGroupUUIDs, ContributorAgreement agreement) throws OrmException {
        AccountGroup ag;
        if (!agreement.getAccepted().isEmpty()) {
            return agreement.getAccepted().get(0).getGroup();
        }
        String name = "CLA Accepted - " + agreement.getName();
        AccountGroupName agn = db.accountGroupNames().get(new AccountGroup.NameKey(name));
        if (agn != null) {
            ag = db.accountGroups().get(agn.getId());
            if (ag == null) {
                throw new IllegalStateException("account group name exists but account group does not: " + name);
            }
            if (!adminGroupUUIDs.contains(ag.getOwnerGroupUUID())) {
                throw new IllegalStateException("individual group exists with non admin owner group: " + name);
            }
        } else {
            ag = this.createGroup(db, name, adminGroupUUIDs.get(0), String.format("Users who have accepted the %s CLA", agreement.getName()));
        }
        GroupReference group = config.resolve(ag);
        agreement.setAccepted(Lists.newArrayList(new PermissionRule(group)));
        if (agreement.getAutoVerify() != null) {
            agreement.setAutoVerify(group);
        }
        List<PermissionRule> sameGroupVisibility = config.getAccountsSection().getSameGroupVisibility();
        PermissionRule rule = new PermissionRule(group);
        rule.setDeny();
        if (!sameGroupVisibility.contains(rule)) {
            sameGroupVisibility.add(rule);
        }
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long addAccountAgreements(ReviewDb db, ProjectConfig config, List<AccountGroup.UUID> adminGroupUUIDs, Map<Integer, ContributorAgreement> agreements) throws SQLException, OrmException {
        try (Statement stmt = ((JdbcSchema)((Object)db)).getConnection().createStatement();){
            long l;
            ResultSet rs = stmt.executeQuery("SELECT account_id, cla_id, accepted_on, reviewed_by,       reviewed_on, review_comments FROM account_agreements WHERE status = 'V'");
            try {
                long minTime = TimeUtil.nowMs();
                while (rs.next()) {
                    int claId;
                    ContributorAgreement agreement;
                    Account.Id accountId = new Account.Id(rs.getInt(1));
                    Account.Id reviewerId = new Account.Id(rs.getInt(4));
                    if (rs.wasNull()) {
                        reviewerId = accountId;
                    }
                    if ((agreement = agreements.get(claId = rs.getInt(2))) == null) continue;
                    Timestamp acceptedOn = rs.getTimestamp(3);
                    minTime = Math.min(minTime, acceptedOn.getTime());
                    GroupReference individualGroup = this.getOrCreateGroupForIndividuals(db, config, adminGroupUUIDs, agreement);
                    AccountGroup.Id groupId = db.accountGroups().byUUID(individualGroup.getUUID()).toList().get(0).getId();
                    AccountGroupMember.Key key = new AccountGroupMember.Key(accountId, groupId);
                    AccountGroupMember m = db.accountGroupMembers().get(key);
                    if (m != null) continue;
                    m = new AccountGroupMember(key);
                    db.accountGroupMembersAudit().insert(Collections.singleton(new AccountGroupMemberAudit(m, reviewerId, acceptedOn)));
                    db.accountGroupMembers().insert(Collections.singleton(m));
                }
                l = minTime;
            }
            catch (Throwable throwable) {
                rs.close();
                throw throwable;
            }
            rs.close();
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<AccountGroupAgreement> getAccountGroupAgreements(ReviewDb db, Map<Integer, ContributorAgreement> agreements) throws SQLException {
        try (Statement stmt = ((JdbcSchema)((Object)db)).getConnection().createStatement();){
            ArrayList<AccountGroupAgreement> arrayList;
            ResultSet rs = stmt.executeQuery("SELECT group_id, cla_id, accepted_on, reviewed_by, reviewed_on,        review_comments FROM account_group_agreements");
            try {
                ArrayList<AccountGroupAgreement> groupAgreements = Lists.newArrayList();
                while (rs.next()) {
                    AccountGroupAgreement a = new AccountGroupAgreement();
                    a.groupId = new AccountGroup.Id(rs.getInt(1));
                    a.claId = rs.getInt(2);
                    if (!agreements.containsKey(a.claId)) continue;
                    a.acceptedOn = rs.getTimestamp(3);
                    a.reviewedBy = new Account.Id(rs.getInt(4));
                    if (rs.wasNull()) {
                        a.reviewedBy = null;
                    }
                    a.reviewedOn = rs.getTimestamp(5);
                    if (rs.wasNull()) {
                        a.reviewedOn = null;
                    }
                    a.reviewComments = rs.getString(6);
                    if (rs.wasNull()) {
                        a.reviewComments = null;
                    }
                    groupAgreements.add(a);
                }
                Collections.sort(groupAgreements, new Comparator<AccountGroupAgreement>(){

                    @Override
                    public int compare(AccountGroupAgreement a1, AccountGroupAgreement a2) {
                        return Long.compare(a1.getTime(), a2.getTime());
                    }
                });
                arrayList = groupAgreements;
            }
            catch (Throwable throwable) {
                rs.close();
                throw throwable;
            }
            rs.close();
            return arrayList;
        }
    }

    private static class AccountGroupAgreement {
        private AccountGroup.Id groupId;
        private int claId;
        private Timestamp acceptedOn;
        private Account.Id reviewedBy;
        private Timestamp reviewedOn;
        private String reviewComments;

        private AccountGroupAgreement() {
        }

        private long getTime() {
            return this.reviewedOn == null ? this.acceptedOn.getTime() : this.reviewedOn.getTime();
        }
    }
}

