/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.schema;

import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.client.AccountGroupById;
import com.google.gerrit.reviewdb.client.AccountGroupByIdAud;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.schema.SchemaVersion;
import com.google.gerrit.server.schema.Schema_73;
import com.google.gerrit.server.schema.UpdateUI;
import com.google.gwtorm.jdbc.JdbcSchema;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;

public class Schema_74
extends SchemaVersion {
    @Inject
    Schema_74(Provider<Schema_73> prior) {
        super(prior);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void migrateData(ReviewDb db, UpdateUI ui) throws SQLException, OrmException {
        HashMap<AccountGroup.Id, AccountGroup.UUID> allGroups = new HashMap<AccountGroup.Id, AccountGroup.UUID>();
        for (AccountGroup ag : db.accountGroups().all()) {
            allGroups.put(ag.getId(), ag.getGroupUUID());
        }
        Connection conn = ((JdbcSchema)((Object)db)).getConnection();
        ArrayList<AccountGroupById> newIncludes = new ArrayList<AccountGroupById>();
        ArrayList<AccountGroupByIdAud> newIncludeAudits = new ArrayList<AccountGroupByIdAud>();
        try (Statement oldGroupIncludesStmt = conn.createStatement();){
            ResultSet oldGroupIncludes = oldGroupIncludesStmt.executeQuery("SELECT * FROM account_group_includes");
            while (oldGroupIncludes.next()) {
                AccountGroup.Id oldGroupId = new AccountGroup.Id(oldGroupIncludes.getInt("group_id"));
                AccountGroup.Id oldIncludeId = new AccountGroup.Id(oldGroupIncludes.getInt("include_id"));
                AccountGroup.UUID uuidFromIncludeId = (AccountGroup.UUID)allGroups.get(oldIncludeId);
                if (uuidFromIncludeId == null) {
                    ui.message("Skipping group_id = \"" + oldIncludeId.get() + "\", not a current group");
                    continue;
                }
                AccountGroupById destIncludeEntry = new AccountGroupById(new AccountGroupById.Key(oldGroupId, uuidFromIncludeId));
                try (PreparedStatement oldAuditsQueryStmt = conn.prepareStatement("SELECT * FROM account_group_includes_audit WHERE group_id=? AND include_id=?");){
                    oldAuditsQueryStmt.setInt(1, oldGroupId.get());
                    oldAuditsQueryStmt.setInt(2, oldIncludeId.get());
                    ResultSet oldGroupIncludeAudits = oldAuditsQueryStmt.executeQuery();
                    while (oldGroupIncludeAudits.next()) {
                        Account.Id addedBy = new Account.Id(oldGroupIncludeAudits.getInt("added_by"));
                        int removedBy = oldGroupIncludeAudits.getInt("removed_by");
                        AccountGroupByIdAud destAuditEntry = new AccountGroupByIdAud(destIncludeEntry, addedBy, oldGroupIncludeAudits.getTimestamp("added_on"));
                        if (removedBy > 0) {
                            destAuditEntry.removed(new Account.Id(removedBy), oldGroupIncludeAudits.getTimestamp("removed_on"));
                        }
                        newIncludeAudits.add(destAuditEntry);
                    }
                    newIncludes.add(destIncludeEntry);
                }
            }
        }
        db.accountGroupById().insert(newIncludes);
        db.accountGroupByIdAud().insert(newIncludeAudits);
    }
}

