/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.schema;

import com.google.gerrit.common.data.AccessSection;
import com.google.gerrit.common.data.Permission;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.GerritPersonIdent;
import com.google.gerrit.server.config.AllProjectsName;
import com.google.gerrit.server.config.SitePaths;
import com.google.gerrit.server.extensions.events.GitReferenceUpdated;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.MetaDataUpdate;
import com.google.gerrit.server.git.ProjectConfig;
import com.google.gerrit.server.schema.SchemaVersion;
import com.google.gerrit.server.schema.Schema_80;
import com.google.gerrit.server.schema.UpdateUI;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.sql.SQLException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;

public class Schema_81
extends SchemaVersion {
    private final File pluginsDir;
    private final GitRepositoryManager mgr;
    private final AllProjectsName allProjects;
    private final PersonIdent serverUser;

    @Inject
    Schema_81(Provider<Schema_80> prior, SitePaths sitePaths, AllProjectsName allProjects, GitRepositoryManager mgr, @GerritPersonIdent PersonIdent serverUser) {
        super(prior);
        this.pluginsDir = sitePaths.plugins_dir;
        this.mgr = mgr;
        this.allProjects = allProjects;
        this.serverUser = serverUser;
    }

    @Override
    protected void migrateData(ReviewDb db, UpdateUI ui) throws OrmException, SQLException {
        try {
            this.migrateStartReplicationCapability(db, this.scanForReplicationPlugin());
        }
        catch (RepositoryNotFoundException e) {
            throw new OrmException(e);
        }
        catch (SQLException e) {
            throw new OrmException(e);
        }
        catch (IOException e) {
            throw new OrmException(e);
        }
        catch (ConfigInvalidException e) {
            throw new OrmException(e);
        }
    }

    private File[] scanForReplicationPlugin() {
        File[] matches = null;
        if (this.pluginsDir != null && this.pluginsDir.exists()) {
            matches = this.pluginsDir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    String n = pathname.getName();
                    return (n.endsWith(".jar") || n.endsWith(".jar.disabled")) && pathname.isFile() && n.contains("replication");
                }
            });
        }
        return matches;
    }

    private void migrateStartReplicationCapability(ReviewDb db, File[] matches) throws SQLException, RepositoryNotFoundException, IOException, ConfigInvalidException {
        Description d = new Description();
        if (matches == null || matches.length == 0) {
            d.what = Description.Action.REMOVE;
        } else {
            d.what = Description.Action.RENAME;
            d.prefix = Schema_81.nameOf(matches[0]);
        }
        this.migrateStartReplicationCapability(db, d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateStartReplicationCapability(ReviewDb db, Description d) throws SQLException, RepositoryNotFoundException, IOException, ConfigInvalidException {
        try (Repository git = this.mgr.openRepository(this.allProjects);){
            MetaDataUpdate md = new MetaDataUpdate(GitReferenceUpdated.DISABLED, this.allProjects, git);
            md.getCommitBuilder().setAuthor(this.serverUser);
            md.getCommitBuilder().setCommitter(this.serverUser);
            ProjectConfig config = ProjectConfig.read(md);
            AccessSection capabilities = config.getAccessSection("GLOBAL_CAPABILITIES");
            Permission startReplication = capabilities.getPermission("startReplication");
            if (startReplication == null) {
                return;
            }
            String msg = null;
            switch (d.what) {
                case REMOVE: {
                    capabilities.remove(startReplication);
                    msg = "Remove startReplication capability, plugin not installed\n";
                    break;
                }
                case RENAME: {
                    capabilities.remove(startReplication);
                    Permission pluginStartReplication = capabilities.getPermission(String.format("%s-startReplication", d.prefix), true);
                    pluginStartReplication.setRules(startReplication.getRules());
                    msg = "Rename startReplication capability to match updated plugin\n";
                }
            }
            config.replace(capabilities);
            md.setMessage(msg);
            config.commit(md);
        }
    }

    private static String nameOf(File jar) {
        int ext;
        String name = jar.getName();
        if (name.endsWith(".disabled")) {
            name = name.substring(0, name.lastIndexOf(46));
        }
        return 0 < (ext = name.lastIndexOf(46)) ? name.substring(0, ext) : name;
    }

    private static class Description {
        Action what;
        String prefix;

        private Description() {
        }

        private static enum Action {
            REMOVE,
            RENAME;

        }
    }
}

