/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.util;

import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.AnonymousUser;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.util.RequestContext;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import com.google.inject.Singleton;

@Singleton
public class FallbackRequestContext
implements RequestContext {
    private final AnonymousUser user;

    @Inject
    FallbackRequestContext(AnonymousUser user) {
        this.user = user;
    }

    @Override
    public CurrentUser getCurrentUser() {
        return this.user;
    }

    @Override
    public Provider<ReviewDb> getReviewDbProvider() {
        return new Provider<ReviewDb>(){

            @Override
            public ReviewDb get() {
                throw new ProvisionException("Automatic ReviewDb only available in request scope");
            }
        };
    }
}

