/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.util;

import java.security.AccessController;
import java.security.PrivilegedAction;

public final class HostPlatform {
    private static final boolean win32 = HostPlatform.computeWin32();

    public static final boolean isWin32() {
        return win32;
    }

    private static final boolean computeWin32() {
        String osDotName = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("os.name");
            }
        });
        return osDotName != null && osDotName.toLowerCase().contains("windows");
    }

    private HostPlatform() {
    }
}

