/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.util;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;

@Singleton
public class IdGenerator {
    private final AtomicInteger gen = new AtomicInteger(new Random().nextInt());
    private static final int salt = -1640531527;

    public static String format(int id) {
        char[] r = new char[8];
        for (int p = 7; 0 <= p; --p) {
            int h = id & 0xF;
            r[p] = h < 10 ? (char)(48 + h) : (char)(97 + (h - 10));
            id >>= 4;
        }
        return new String(r);
    }

    @Inject
    IdGenerator() {
    }

    public int next() {
        return IdGenerator.mix(this.gen.getAndIncrement());
    }

    static int mix(int in) {
        return IdGenerator.mix(-1640531527, in);
    }

    public static int mix(int salt, int in) {
        short v0 = IdGenerator.hi16(in);
        short v1 = IdGenerator.lo16(in);
        v0 = (short)(v0 + (((v1 << 2) + 0 ^ v1) + (salt ^ v1 >>> 3) + 1));
        v1 = (short)(v1 + (((v0 << 2) + 2 ^ v0) + (salt ^ v0 >>> 3) + 3));
        return IdGenerator.result(v0, v1);
    }

    static int unmix(int in) {
        short v0 = IdGenerator.hi16(in);
        short v1 = IdGenerator.lo16(in);
        v1 = (short)(v1 - (((v0 << 2) + 2 ^ v0) + (0x9E3779B9 ^ v0 >>> 3) + 3));
        v0 = (short)(v0 - (((v1 << 2) + 0 ^ v1) + (0x9E3779B9 ^ v1 >>> 3) + 1));
        return IdGenerator.result(v0, v1);
    }

    private static short hi16(int in) {
        return (short)(in >>> 24 & 0xFF | (in >>> 16 & 0xFF) << 8);
    }

    private static short lo16(int in) {
        return (short)(in >>> 8 & 0xFF | (in & 0xFF) << 8);
    }

    private static int result(short v0, short v1) {
        return (v0 & 0xFF) << 24 | (v0 >>> 8 & 0xFF) << 16 | (v1 & 0xFF) << 8 | v1 >>> 8 & 0xFF;
    }
}

