/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd;

import com.google.common.base.Preconditions;
import com.google.gerrit.extensions.annotations.PluginName;
import com.google.gerrit.sshd.BaseCommand;
import com.google.gerrit.sshd.CommandModule;
import com.google.gerrit.sshd.CommandName;
import com.google.gerrit.sshd.Commands;
import com.google.gerrit.sshd.DispatchCommandProvider;
import com.google.inject.binder.LinkedBindingBuilder;
import javax.inject.Inject;
import org.apache.sshd.server.Command;

public abstract class PluginCommandModule
extends CommandModule {
    private CommandName command;

    @Inject
    void setPluginName(@PluginName String name) {
        this.command = Commands.named(name);
    }

    @Override
    protected final void configure() {
        Preconditions.checkState(this.command != null, "@PluginName must be provided");
        this.bind(Commands.key(this.command)).toProvider(new DispatchCommandProvider(this.command));
        this.configureCommands();
    }

    protected abstract void configureCommands();

    @Override
    protected LinkedBindingBuilder<Command> command(String subCmd) {
        return this.bind(Commands.key(this.command, subCmd));
    }

    protected void command(Class<? extends BaseCommand> clazz) {
        this.command(this.command, clazz);
    }

    protected void alias(String name, Class<? extends BaseCommand> clazz) {
        this.alias(this.command, name, clazz);
    }
}

