/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd;

import com.google.common.base.Preconditions;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.gerrit.extensions.annotations.Export;
import com.google.gerrit.server.plugins.AutoRegisterUtil;
import com.google.gerrit.server.plugins.InvalidPluginException;
import com.google.gerrit.server.plugins.ModuleGenerator;
import com.google.gerrit.sshd.CommandName;
import com.google.gerrit.sshd.Commands;
import com.google.gerrit.sshd.DispatchCommandProvider;
import com.google.gerrit.sshd.SshCommand;
import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import java.lang.annotation.Annotation;
import java.util.Map;
import org.apache.sshd.server.Command;

class SshAutoRegisterModuleGenerator
extends AbstractModule
implements ModuleGenerator {
    private final Map<String, Class<Command>> commands = Maps.newHashMap();
    private final Multimap<TypeLiteral<?>, Class<?>> listeners = LinkedListMultimap.create();
    private CommandName command;

    SshAutoRegisterModuleGenerator() {
    }

    @Override
    protected void configure() {
        this.bind(Commands.key(this.command)).toProvider(new DispatchCommandProvider(this.command));
        for (Map.Entry<String, Class<Command>> entry : this.commands.entrySet()) {
            this.bind(Commands.key(this.command, entry.getKey())).to(entry.getValue());
        }
        for (Map.Entry<Object, Class<Command>> entry : this.listeners.entries()) {
            TypeLiteral type = (TypeLiteral)entry.getKey();
            Class<Object> impl = entry.getValue();
            Annotation n = AutoRegisterUtil.calculateBindAnnotation(impl);
            this.bind(type).annotatedWith(n).to(impl);
        }
    }

    @Override
    public void setPluginName(String name) {
        this.command = Commands.named(name);
    }

    @Override
    public void export(Export export, Class<?> type) throws InvalidPluginException {
        Preconditions.checkState(this.command != null, "pluginName must be provided");
        if (Command.class.isAssignableFrom(type)) {
            Class<Command> old = this.commands.get(export.value());
            if (old != null) {
                throw new InvalidPluginException(String.format("@Export(\"%s\") has duplicate bindings:\n  %s\n  %s", export.value(), old.getName(), type.getName()));
            }
        } else {
            throw new InvalidPluginException(String.format("Class %s with @Export(\"%s\") must extend %s or implement %s", type.getName(), export.value(), SshCommand.class.getName(), Command.class.getName()));
        }
        this.commands.put(export.value(), type);
    }

    @Override
    public void listen(TypeLiteral<?> tl, Class<?> clazz) {
        this.listeners.put(tl, clazz);
    }

    @Override
    public Module create() throws InvalidPluginException {
        Preconditions.checkState(this.command != null, "pluginName must be provided");
        return !this.commands.isEmpty() ? this : null;
    }
}

