/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd;

import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.gerrit.common.errors.InvalidSshKeyException;
import com.google.gerrit.reviewdb.client.AccountExternalId;
import com.google.gerrit.reviewdb.client.AccountSshKey;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.cache.CacheModule;
import com.google.gerrit.server.ssh.SshKeyCache;
import com.google.gerrit.sshd.SshKeyCacheEntry;
import com.google.gerrit.sshd.SshUtil;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.SchemaFactory;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Named;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SshKeyCacheImpl
implements SshKeyCache {
    private static final Logger log = LoggerFactory.getLogger(SshKeyCacheImpl.class);
    private static final String CACHE_NAME = "sshkeys";
    static final Iterable<SshKeyCacheEntry> NO_SUCH_USER = SshKeyCacheImpl.none();
    static final Iterable<SshKeyCacheEntry> NO_KEYS = SshKeyCacheImpl.none();
    private final LoadingCache<String, Iterable<SshKeyCacheEntry>> cache;

    public static Module module() {
        return new CacheModule(){

            @Override
            protected void configure() {
                this.cache(SshKeyCacheImpl.CACHE_NAME, String.class, new TypeLiteral<Iterable<SshKeyCacheEntry>>(){}).loader(Loader.class);
                this.bind(SshKeyCacheImpl.class);
                this.bind(SshKeyCache.class).to(SshKeyCacheImpl.class);
            }
        };
    }

    private static Iterable<SshKeyCacheEntry> none() {
        return Collections.unmodifiableCollection(Arrays.asList(new SshKeyCacheEntry[0]));
    }

    @Inject
    SshKeyCacheImpl(@Named(value="sshkeys") LoadingCache<String, Iterable<SshKeyCacheEntry>> cache) {
        this.cache = cache;
    }

    Iterable<SshKeyCacheEntry> get(String username) {
        try {
            return this.cache.get(username);
        }
        catch (ExecutionException e) {
            log.warn("Cannot load SSH keys for " + username, e);
            return Collections.emptyList();
        }
    }

    @Override
    public void evict(String username) {
        if (username != null) {
            this.cache.invalidate(username);
        }
    }

    @Override
    public AccountSshKey create(AccountSshKey.Id id, String encoded) throws InvalidSshKeyException {
        try {
            AccountSshKey key = new AccountSshKey(id, SshUtil.toOpenSshPublicKey(encoded));
            SshUtil.parse(key);
            return key;
        }
        catch (NoSuchAlgorithmException e) {
            throw new InvalidSshKeyException();
        }
        catch (InvalidKeySpecException e) {
            throw new InvalidSshKeyException();
        }
        catch (NoSuchProviderException e) {
            log.error("Cannot parse SSH key", e);
            throw new InvalidSshKeyException();
        }
    }

    static class Loader
    extends CacheLoader<String, Iterable<SshKeyCacheEntry>> {
        private final SchemaFactory<ReviewDb> schema;

        @Inject
        Loader(SchemaFactory<ReviewDb> schema) {
            this.schema = schema;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Iterable<SshKeyCacheEntry> load(String username) throws Exception {
            try (ReviewDb db = this.schema.open();){
                Iterable<SshKeyCacheEntry> iterable;
                AccountExternalId.Key key = new AccountExternalId.Key("username:", username);
                AccountExternalId user = db.accountExternalIds().get(key);
                if (user == null) {
                    Iterable<SshKeyCacheEntry> iterable2 = NO_SUCH_USER;
                    return iterable2;
                }
                ArrayList<SshKeyCacheEntry> kl = new ArrayList<SshKeyCacheEntry>(4);
                for (AccountSshKey k : db.accountSshKeys().byAccount(user.getAccountId())) {
                    if (!k.isValid()) continue;
                    this.add(db, kl, k);
                }
                if (kl.isEmpty()) {
                    iterable = NO_KEYS;
                    return iterable;
                }
                iterable = Collections.unmodifiableList(kl);
                return iterable;
            }
        }

        private void add(ReviewDb db, List<SshKeyCacheEntry> kl, AccountSshKey k) {
            try {
                kl.add(new SshKeyCacheEntry(k.getKey(), SshUtil.parse(k)));
            }
            catch (OutOfMemoryError e) {
                throw e;
            }
            catch (Throwable e) {
                this.markInvalid(db, k);
            }
        }

        private void markInvalid(ReviewDb db, AccountSshKey k) {
            try {
                log.info("Flagging SSH key " + k.getKey() + " invalid");
                k.setInvalid();
                db.accountSshKeys().update(Collections.singleton(k));
            }
            catch (OrmException e) {
                log.error("Failed to mark SSH key" + k.getKey() + " invalid", e);
            }
        }
    }
}

