/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd;

import com.google.gerrit.server.plugins.Plugin;
import com.google.gerrit.server.plugins.ReloadPluginListener;
import com.google.gerrit.server.plugins.StartPluginListener;
import com.google.gerrit.sshd.CommandName;
import com.google.gerrit.sshd.Commands;
import com.google.gerrit.sshd.DispatchCommandProvider;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import javax.inject.Inject;
import org.apache.sshd.server.Command;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
class SshPluginStarterCallback
implements StartPluginListener,
ReloadPluginListener {
    private static final Logger log = LoggerFactory.getLogger(SshPluginStarterCallback.class);
    private final DispatchCommandProvider root;

    @Inject
    SshPluginStarterCallback(@CommandName(value="") DispatchCommandProvider root) {
        this.root = root;
    }

    @Override
    public void onStartPlugin(Plugin plugin) {
        Provider<Command> cmd = this.load(plugin);
        if (cmd != null) {
            plugin.add(this.root.register(Commands.named(plugin.getName()), cmd));
        }
    }

    @Override
    public void onReloadPlugin(Plugin oldPlugin, Plugin newPlugin) {
        Provider<Command> cmd = this.load(newPlugin);
        if (cmd != null) {
            newPlugin.add(this.root.replace(Commands.named(newPlugin.getName()), cmd));
        }
    }

    private Provider<Command> load(Plugin plugin) {
        if (plugin.getSshInjector() != null) {
            Key<Command> key = Commands.key(plugin.getName());
            try {
                return plugin.getSshInjector().getProvider(key);
            }
            catch (RuntimeException err) {
                log.warn(String.format("Plugin %s did not define its top-level command", plugin.getName()), err);
            }
        }
        return null;
    }
}

