/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd.commands;

import com.google.gerrit.common.data.LabelType;
import com.google.gerrit.common.data.LabelValue;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.OptionDef;
import org.kohsuke.args4j.spi.FieldSetter;
import org.kohsuke.args4j.spi.OneArgumentOptionHandler;
import org.kohsuke.args4j.spi.OptionHandler;
import org.kohsuke.args4j.spi.Setter;

final class ApproveOption
implements Option,
Setter<Short> {
    private final String name;
    private final String usage;
    private final LabelType type;
    private Short value;

    ApproveOption(String name, String usage, LabelType type) {
        this.name = name;
        this.usage = usage;
        this.type = type;
    }

    @Override
    public String[] aliases() {
        return new String[0];
    }

    @Override
    public String[] depends() {
        return new String[0];
    }

    @Override
    public boolean hidden() {
        return false;
    }

    public Class<? extends OptionHandler<Short>> handler() {
        return Handler.class;
    }

    @Override
    public String metaVar() {
        return "N";
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public boolean required() {
        return false;
    }

    @Override
    public String usage() {
        return this.usage;
    }

    public Short value() {
        return this.value;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return null;
    }

    @Override
    public FieldSetter asFieldSetter() {
        throw new UnsupportedOperationException();
    }

    @Override
    public AnnotatedElement asAnnotatedElement() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addValue(Short val) {
        this.value = val;
    }

    @Override
    public Class<Short> getType() {
        return Short.class;
    }

    @Override
    public boolean isMultiValued() {
        return false;
    }

    String getLabelName() {
        return this.type.getName();
    }

    public static class Handler
    extends OneArgumentOptionHandler<Short> {
        private final ApproveOption cmdOption;

        public Handler(CmdLineParser parser, OptionDef option, Setter<Short> setter) {
            super(parser, option, setter);
            this.cmdOption = (ApproveOption)setter;
        }

        @Override
        protected Short parse(String token) throws NumberFormatException, CmdLineException {
            String argument = token;
            if (argument.startsWith("+")) {
                argument = argument.substring(1);
            }
            short value = Short.parseShort(argument);
            LabelValue min = this.cmdOption.type.getMin();
            LabelValue max = this.cmdOption.type.getMax();
            if (value < min.getValue() || value > max.getValue()) {
                String name = this.cmdOption.name();
                String e = "\"" + token + "\" must be in range " + min.formatValue() + ".." + max.formatValue() + " for \"" + name + "\"";
                throw new CmdLineException(this.owner, e);
            }
            return value;
        }
    }
}

