/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd.commands;

import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.restapi.TopLevelResource;
import com.google.gerrit.server.OutputFormat;
import com.google.gerrit.server.change.ChangesCollection;
import com.google.gerrit.server.change.RevisionResource;
import com.google.gerrit.server.change.Revisions;
import com.google.gerrit.server.change.TestSubmitRule;
import com.google.gerrit.sshd.BaseCommand;
import com.google.gerrit.sshd.SshCommand;
import com.google.inject.Inject;
import java.nio.ByteBuffer;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.RawParseUtils;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

abstract class BaseTestPrologCommand
extends SshCommand {
    private TestSubmitRule.Input input = new TestSubmitRule.Input();
    @Inject
    private ChangesCollection changes;
    @Inject
    private Revisions revisions;
    @Argument(index=0, required=true, usage="ChangeId to load in prolog environment")
    protected String changeId;
    @Option(name="-s", usage="Read prolog script from stdin instead of reading rules.pl from the refs/meta/config branch")
    protected boolean useStdin;

    BaseTestPrologCommand() {
    }

    @Option(name="--no-filters", aliases={"-n"}, usage="Don't run the submit_filter/2 from the parent projects")
    void setNoFilters(boolean no) {
        this.input.filters = no ? TestSubmitRule.Filters.SKIP : TestSubmitRule.Filters.RUN;
    }

    protected abstract RestModifyView<RevisionResource, TestSubmitRule.Input> createView();

    @Override
    protected final void run() throws BaseCommand.UnloggedFailure {
        try {
            RevisionResource revision = this.revisions.parse(this.changes.parse(TopLevelResource.INSTANCE, IdString.fromUrl(this.changeId)), IdString.fromUrl("current"));
            if (this.useStdin) {
                ByteBuffer buf = IO.readWholeStream(this.in, 4096);
                this.input.rule = RawParseUtils.decode(buf.array(), buf.arrayOffset(), buf.limit());
            }
            Object result = this.createView().apply(revision, this.input);
            OutputFormat.JSON.newGson().toJson(result, (Appendable)this.stdout);
            this.stdout.print('\n');
        }
        catch (Exception e) {
            throw new BaseCommand.UnloggedFailure("Processing of prolog script failed: " + e);
        }
    }
}

