/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd.commands;

import com.google.common.cache.Cache;
import com.google.common.collect.Sets;
import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.sshd.SshCommand;
import com.google.inject.Inject;
import java.util.SortedSet;
import java.util.TreeSet;

abstract class CacheCommand
extends SshCommand {
    @Inject
    protected DynamicMap<Cache<?, ?>> cacheMap;

    CacheCommand() {
    }

    protected SortedSet<String> cacheNames() {
        TreeSet<String> names = Sets.newTreeSet();
        for (DynamicMap.Entry<Cache<?, ?>> entry : this.cacheMap) {
            names.add(this.cacheNameOf(entry.getPluginName(), entry.getExportName()));
        }
        return names;
    }

    protected String cacheNameOf(String plugin, String name) {
        if ("gerrit".equals(plugin)) {
            return name;
        }
        return plugin + "." + name;
    }
}

