/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd.commands;

import com.google.gerrit.sshd.CommandModule;
import com.google.gerrit.sshd.CommandName;
import com.google.gerrit.sshd.Commands;
import com.google.gerrit.sshd.DispatchCommandProvider;
import com.google.gerrit.sshd.SuExec;
import com.google.gerrit.sshd.commands.AdminQueryShell;
import com.google.gerrit.sshd.commands.AdminSetParent;
import com.google.gerrit.sshd.commands.AproposCommand;
import com.google.gerrit.sshd.commands.BanCommitCommand;
import com.google.gerrit.sshd.commands.CreateAccountCommand;
import com.google.gerrit.sshd.commands.CreateBranchCommand;
import com.google.gerrit.sshd.commands.CreateGroupCommand;
import com.google.gerrit.sshd.commands.CreateProjectCommand;
import com.google.gerrit.sshd.commands.FlushCaches;
import com.google.gerrit.sshd.commands.GarbageCollectionCommand;
import com.google.gerrit.sshd.commands.KillCommand;
import com.google.gerrit.sshd.commands.ListGroupsCommand;
import com.google.gerrit.sshd.commands.ListMembersCommand;
import com.google.gerrit.sshd.commands.ListProjectsCommand;
import com.google.gerrit.sshd.commands.LsUserRefs;
import com.google.gerrit.sshd.commands.PluginEnableCommand;
import com.google.gerrit.sshd.commands.PluginInstallCommand;
import com.google.gerrit.sshd.commands.PluginLsCommand;
import com.google.gerrit.sshd.commands.PluginReloadCommand;
import com.google.gerrit.sshd.commands.PluginRemoveCommand;
import com.google.gerrit.sshd.commands.Query;
import com.google.gerrit.sshd.commands.Receive;
import com.google.gerrit.sshd.commands.RenameGroupCommand;
import com.google.gerrit.sshd.commands.ReviewCommand;
import com.google.gerrit.sshd.commands.ScpCommand;
import com.google.gerrit.sshd.commands.SetAccountCommand;
import com.google.gerrit.sshd.commands.SetMembersCommand;
import com.google.gerrit.sshd.commands.SetProjectCommand;
import com.google.gerrit.sshd.commands.SetReviewersCommand;
import com.google.gerrit.sshd.commands.ShowCaches;
import com.google.gerrit.sshd.commands.ShowConnections;
import com.google.gerrit.sshd.commands.ShowQueue;
import com.google.gerrit.sshd.commands.StreamEvents;
import com.google.gerrit.sshd.commands.TestSubmitRuleCommand;
import com.google.gerrit.sshd.commands.TestSubmitTypeCommand;
import com.google.gerrit.sshd.commands.Upload;
import com.google.gerrit.sshd.commands.VersionCommand;

public class DefaultCommandModule
extends CommandModule {
    public DefaultCommandModule(boolean slave) {
        this.slaveMode = slave;
    }

    @Override
    protected void configure() {
        CommandName git = Commands.named("git");
        CommandName gerrit = Commands.named("gerrit");
        CommandName plugin = Commands.named(gerrit, "plugin");
        CommandName testSubmit = Commands.named(gerrit, "test-submit");
        this.command(gerrit).toProvider(new DispatchCommandProvider(gerrit));
        this.command(gerrit, AproposCommand.class);
        this.command(gerrit, BanCommitCommand.class);
        this.command(gerrit, FlushCaches.class);
        this.command(gerrit, ListProjectsCommand.class);
        this.command(gerrit, ListMembersCommand.class);
        this.command(gerrit, ListGroupsCommand.class);
        this.command(gerrit, LsUserRefs.class);
        this.command(gerrit, Query.class);
        this.command(gerrit, ShowCaches.class);
        this.command(gerrit, ShowConnections.class);
        this.command(gerrit, ShowQueue.class);
        this.command(gerrit, StreamEvents.class);
        this.command(gerrit, VersionCommand.class);
        this.command(gerrit, GarbageCollectionCommand.class);
        this.command(gerrit, "plugin").toProvider(new DispatchCommandProvider(plugin));
        this.command(plugin, PluginLsCommand.class);
        this.command(plugin, PluginEnableCommand.class);
        this.command(plugin, PluginInstallCommand.class);
        this.command(plugin, PluginReloadCommand.class);
        this.command(plugin, PluginRemoveCommand.class);
        this.alias(plugin, "add", PluginInstallCommand.class);
        this.alias(plugin, "rm", PluginRemoveCommand.class);
        this.command(git).toProvider(new DispatchCommandProvider(git));
        this.command("ps").to(ShowQueue.class);
        this.command("kill").to(KillCommand.class);
        this.command("scp").to(ScpCommand.class);
        this.command("git-upload-pack").to(Commands.key(git, "upload-pack"));
        this.command(git, "upload-pack").to(Upload.class);
        this.command("suexec").to(SuExec.class);
        this.listener().to(ShowCaches.StartupListener.class);
        this.command(gerrit, CreateAccountCommand.class);
        this.command(gerrit, CreateGroupCommand.class);
        this.command(gerrit, CreateProjectCommand.class);
        this.command(gerrit, AdminQueryShell.class);
        if (!this.slaveMode) {
            this.command("git-receive-pack").to(Commands.key(git, "receive-pack"));
            this.command("gerrit-receive-pack").to(Commands.key(git, "receive-pack"));
            this.command(git, "receive-pack").to(Commands.key(gerrit, "receive-pack"));
            this.command(gerrit, "test-submit").toProvider(new DispatchCommandProvider(testSubmit));
        }
        this.command(gerrit, Receive.class);
        this.command(gerrit, RenameGroupCommand.class);
        this.command(gerrit, ReviewCommand.class);
        this.command(gerrit, SetProjectCommand.class);
        this.command(gerrit, SetReviewersCommand.class);
        this.command(gerrit, SetMembersCommand.class);
        this.command(gerrit, CreateBranchCommand.class);
        this.command(gerrit, SetAccountCommand.class);
        this.command(gerrit, AdminSetParent.class);
        this.command(gerrit, CreateAccountCommand.class);
        this.command(testSubmit, TestSubmitRuleCommand.class);
        this.command(testSubmit, TestSubmitTypeCommand.class);
    }
}

