/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd.commands;

import com.google.common.base.Objects;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.git.TaskInfoFactory;
import com.google.gerrit.server.git.WorkQueue;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.project.ProjectState;
import com.google.gerrit.server.util.IdGenerator;
import com.google.gerrit.server.util.TimeUtil;
import com.google.gerrit.sshd.AdminHighPriorityCommand;
import com.google.gerrit.sshd.CommandMetaData;
import com.google.gerrit.sshd.SshCommand;
import com.google.inject.Inject;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.server.Environment;
import org.kohsuke.args4j.Option;

@AdminHighPriorityCommand
@CommandMetaData(name="show-queue", description="Display the background work queues", runsAt=CommandMetaData.Mode.MASTER_OR_SLAVE)
final class ShowQueue
extends SshCommand {
    @Option(name="--wide", aliases={"-w"}, usage="display without line width truncation")
    private boolean wide;
    @Inject
    private WorkQueue workQueue;
    @Inject
    private ProjectCache projectCache;
    @Inject
    private IdentifiedUser currentUser;
    private int columns = 80;
    private int taskNameWidth;

    ShowQueue() {
    }

    @Override
    public void start(Environment env) throws IOException {
        String s = env.getEnv().get("COLUMNS");
        if (s != null && !s.isEmpty()) {
            try {
                this.columns = Integer.parseInt(s);
            }
            catch (NumberFormatException err) {
                this.columns = 80;
            }
        }
        super.start(env);
    }

    @Override
    protected void run() {
        this.taskNameWidth = this.wide ? Integer.MAX_VALUE : this.columns - 8 - 12 - 12 - 4 - 4;
        List<QueueTaskInfo> pending = this.getSortedTaskInfoList();
        this.stdout.print(String.format("%-8s %-12s %-12s %-4s %s\n", "Task", "State", "StartTime", "", "Command"));
        this.stdout.print("------------------------------------------------------------------------------\n");
        int numberOfPendingTasks = 0;
        long now = TimeUtil.nowMs();
        boolean viewAll = this.currentUser.getCapabilities().canViewQueue();
        for (QueueTaskInfo taskInfo : pending) {
            String start;
            long delay = taskInfo.delayMillis;
            WorkQueue.Task.State state = taskInfo.state;
            switch (state) {
                case DONE: 
                case CANCELLED: 
                case RUNNING: 
                case READY: {
                    start = ShowQueue.format(state);
                    break;
                }
                default: {
                    start = ShowQueue.time(now, delay);
                }
            }
            boolean regularUserCanSee = false;
            boolean hasCustomizedPrint = true;
            Project.NameKey projectName = null;
            String remoteName = null;
            if (!viewAll) {
                projectName = taskInfo.getProjectNameKey();
                remoteName = taskInfo.getRemoteName();
                hasCustomizedPrint = taskInfo.hasCustomizedPrint();
                ProjectState e = null;
                if (projectName != null) {
                    e = this.projectCache.get(projectName);
                }
                boolean bl = regularUserCanSee = e != null && e.controlFor(this.currentUser).isVisible();
                if (regularUserCanSee) {
                    ++numberOfPendingTasks;
                }
            }
            String startTime = ShowQueue.startTime(taskInfo.getStartTime());
            if (viewAll || !hasCustomizedPrint && regularUserCanSee) {
                this.stdout.print(String.format("%8s %-12s %-12s %-4s %s\n", ShowQueue.id(taskInfo.getTaskId()), start, startTime, "", taskInfo.getTaskString(this.taskNameWidth)));
                continue;
            }
            if (!regularUserCanSee) continue;
            if (projectName != null) {
                remoteName = remoteName == null ? projectName.get() : remoteName + "/" + projectName.get();
            }
            this.stdout.print(String.format("%8s %-12s %-4s %s\n", ShowQueue.id(taskInfo.getTaskId()), start, startTime, Objects.firstNonNull(remoteName, "n/a")));
        }
        this.stdout.print("------------------------------------------------------------------------------\n");
        if (viewAll) {
            numberOfPendingTasks = pending.size();
        }
        this.stdout.print("  " + numberOfPendingTasks + " tasks\n");
    }

    private List<QueueTaskInfo> getSortedTaskInfoList() {
        List<QueueTaskInfo> taskInfos = this.workQueue.getTaskInfos(new TaskInfoFactory<QueueTaskInfo>(){

            @Override
            public QueueTaskInfo getTaskInfo(WorkQueue.Task<?> task) {
                return new QueueTaskInfo(task);
            }
        });
        Collections.sort(taskInfos, new Comparator<QueueTaskInfo>(){

            @Override
            public int compare(QueueTaskInfo a, QueueTaskInfo b) {
                if (a.state != b.state) {
                    return a.state.ordinal() - b.state.ordinal();
                }
                int cmp = Long.signum(a.delayMillis - b.delayMillis);
                if (cmp != 0) {
                    return cmp;
                }
                return a.getTaskString(ShowQueue.this.taskNameWidth).compareTo(b.getTaskString(ShowQueue.this.taskNameWidth));
            }
        });
        return taskInfos;
    }

    private static String id(int id) {
        return IdGenerator.format(id);
    }

    private static String time(long now, long delay) {
        Date when = new Date(now + delay);
        return ShowQueue.format(when, delay);
    }

    private static String startTime(Date when) {
        return ShowQueue.format(when, TimeUtil.nowMs() - when.getTime());
    }

    private static String format(Date when, long timeFromNow) {
        if (timeFromNow < 86400000L) {
            return new SimpleDateFormat("HH:mm:ss.SSS").format(when);
        }
        return new SimpleDateFormat("MMM-dd HH:mm").format(when);
    }

    private static String format(WorkQueue.Task.State state) {
        switch (state) {
            case DONE: {
                return "....... done";
            }
            case CANCELLED: {
                return "..... killed";
            }
            case RUNNING: {
                return "";
            }
            case READY: {
                return "waiting ....";
            }
            case SLEEPING: {
                return "sleeping";
            }
        }
        return state.toString();
    }

    private static class QueueTaskInfo {
        private final long delayMillis;
        private final WorkQueue.Task.State state;
        private final WorkQueue.Task<?> task;

        QueueTaskInfo(WorkQueue.Task<?> task) {
            this.task = task;
            this.delayMillis = task.getDelay(TimeUnit.MILLISECONDS);
            this.state = task.getState();
        }

        String getRemoteName() {
            if (this.task instanceof WorkQueue.ProjectTask) {
                return ((WorkQueue.ProjectTask)this.task).getRemoteName();
            }
            return null;
        }

        Project.NameKey getProjectNameKey() {
            if (this.task instanceof WorkQueue.ProjectTask) {
                return ((WorkQueue.ProjectTask)this.task).getProjectNameKey();
            }
            return null;
        }

        boolean hasCustomizedPrint() {
            if (this.task instanceof WorkQueue.ProjectTask) {
                return ((WorkQueue.ProjectTask)this.task).hasCustomizedPrint();
            }
            return false;
        }

        int getTaskId() {
            return this.task.getTaskId();
        }

        Date getStartTime() {
            return this.task.getStartTime();
        }

        String getTaskString(int maxLength) {
            String s = this.task.toString();
            return s.length() < maxLength ? s : s.substring(0, maxLength);
        }
    }
}

