/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd.commands;

import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.git.ChangeCache;
import com.google.gerrit.server.git.TagCache;
import com.google.gerrit.server.git.TransferConfig;
import com.google.gerrit.server.git.VisibleRefFilter;
import com.google.gerrit.sshd.AbstractGitCommand;
import com.google.gerrit.sshd.BaseCommand;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import org.eclipse.jgit.transport.UploadPack;

final class Upload
extends AbstractGitCommand {
    @Inject
    private Provider<ReviewDb> db;
    @Inject
    private TransferConfig config;
    @Inject
    private TagCache tagCache;
    @Inject
    private ChangeCache changeCache;

    Upload() {
    }

    @Override
    protected void runImpl() throws IOException, BaseCommand.Failure {
        if (!this.projectControl.canRunUploadPack()) {
            throw new BaseCommand.Failure(1, "fatal: upload-pack not permitted on this server");
        }
        UploadPack up = new UploadPack(this.repo);
        if (!this.projectControl.allRefsAreVisible()) {
            up.setAdvertiseRefsHook(new VisibleRefFilter(this.tagCache, this.changeCache, this.repo, this.projectControl, this.db.get(), true));
        }
        up.setPackConfig(this.config.getPackConfig());
        up.setTimeout(this.config.getTimeout());
        up.upload(this.in, this.out, this.err);
    }
}

