/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtexpui.server;

import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CacheHeaders {
    private static final long MAX_CACHE_DURATION = TimeUnit.DAYS.toSeconds(365L);

    public static void setNotCacheable(HttpServletResponse res) {
        String cc = "no-cache, no-store, max-age=0, must-revalidate";
        res.setHeader("Cache-Control", cc);
        res.setHeader("Pragma", "no-cache");
        res.setHeader("Expires", "Fri, 01 Jan 1990 00:00:00 GMT");
        res.setDateHeader("Date", System.currentTimeMillis());
    }

    public static void setCacheable(HttpServletRequest req, HttpServletResponse res, long age, TimeUnit unit) {
        CacheHeaders.setCacheable(req, res, age, unit, false);
    }

    public static void setCacheable(HttpServletRequest req, HttpServletResponse res, long age, TimeUnit unit, boolean mustRevalidate) {
        if (req.isSecure()) {
            CacheHeaders.setCacheablePrivate(res, age, unit, mustRevalidate);
        } else {
            CacheHeaders.setCacheablePublic(res, age, unit, mustRevalidate);
        }
    }

    public static void setCacheablePublic(HttpServletResponse res, long age, TimeUnit unit, boolean mustRevalidate) {
        long now = System.currentTimeMillis();
        long sec = CacheHeaders.maxAgeSeconds(age, unit);
        res.setDateHeader("Expires", now + TimeUnit.SECONDS.toMillis(sec));
        res.setDateHeader("Date", now);
        CacheHeaders.cache(res, "public", age, unit, mustRevalidate);
    }

    public static void setCacheablePrivate(HttpServletResponse res, long age, TimeUnit unit, boolean mustRevalidate) {
        long now = System.currentTimeMillis();
        res.setDateHeader("Expires", now);
        res.setDateHeader("Date", now);
        CacheHeaders.cache(res, "private", age, unit, mustRevalidate);
    }

    private static void cache(HttpServletResponse res, String type, long age, TimeUnit unit, boolean revalidate) {
        res.setHeader("Cache-Control", String.format("%s, max-age=%d%s", type, CacheHeaders.maxAgeSeconds(age, unit), revalidate ? ", must-revalidate" : ""));
    }

    private static long maxAgeSeconds(long age, TimeUnit unit) {
        return Math.min(unit.toSeconds(age), MAX_CACHE_DURATION);
    }

    private CacheHeaders() {
    }
}

