/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtjsonrpc.client;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwtjsonrpc.client.JsonUtil;
import com.google.gwtjsonrpc.client.impl.ResultDeserializer;
import com.google.gwtjsonrpc.common.AsyncCallback;

public class CallbackHandle<R> {
    private static int callbackId;
    private final ResultDeserializer<R> deserializer;
    private final AsyncCallback<R> callback;
    private int functionId;

    private static int nextFunction() {
        return ++callbackId;
    }

    public CallbackHandle(ResultDeserializer<R> ser, AsyncCallback<R> ac) {
        this.deserializer = ser;
        this.callback = ac;
    }

    public void install() {
        if (this.functionId == 0) {
            this.functionId = CallbackHandle.nextFunction();
            CallbackHandle.nativeInstall(this.functionId, this);
        }
    }

    public String getFunctionName() {
        assert (this.functionId > 0);
        return "__gwtjsonrpc_callbackhandle[" + this.functionId + "]";
    }

    public void cancel() {
        if (this.functionId > 0) {
            CallbackHandle.nativeDelete(this.functionId);
            this.functionId = 0;
        }
    }

    final void onResult(JavaScriptObject rpcResult) {
        this.cancel();
        JsonUtil.invoke(this.deserializer, this.callback, rpcResult);
    }

    private static final native void nativeInit();

    private static final native void nativeDelete(int var0);

    private static final native void nativeInstall(int var0, CallbackHandle<?> var1);

    static {
        CallbackHandle.nativeInit();
    }
}

