/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtjsonrpc.server;

import com.google.gwtjsonrpc.common.AllowCrossSiteRequest;
import com.google.gwtjsonrpc.common.RemoteJsonService;
import com.google.gwtjsonrpc.server.ActiveCall;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

public class MethodHandle {
    private final RemoteJsonService imp;
    private final Method method;
    private final Type[] parameterTypes;
    private final boolean allowXsrf;

    MethodHandle(RemoteJsonService imp, Method method) {
        this.imp = imp;
        this.method = method;
        this.allowXsrf = method.getAnnotation(AllowCrossSiteRequest.class) != null;
        Type[] args = method.getGenericParameterTypes();
        this.parameterTypes = new Type[args.length - 1];
        System.arraycopy(args, 0, this.parameterTypes, 0, this.parameterTypes.length);
    }

    public String getName() {
        return this.method.getName();
    }

    public <T extends Annotation> T getAnnotation(Class<T> t) {
        return this.method.getAnnotation(t);
    }

    public Type[] getParamTypes() {
        return this.parameterTypes;
    }

    public boolean allowCrossSiteRequest() {
        return this.allowXsrf;
    }

    public void invoke(Object[] arguments, ActiveCall callback) {
        try {
            Object[] p = new Object[arguments.length + 1];
            System.arraycopy(arguments, 0, p, 0, arguments.length);
            p[p.length - 1] = callback;
            this.method.invoke((Object)this.imp, p);
        }
        catch (InvocationTargetException e) {
            Throwable c = e.getCause();
            if (c != null) {
                callback.onInternalFailure(c);
            } else {
                callback.onInternalFailure(e);
            }
        }
        catch (IllegalAccessException e) {
            callback.onInternalFailure(e);
        }
        catch (RuntimeException e) {
            callback.onInternalFailure(e);
        }
        catch (Error e) {
            callback.onInternalFailure(e);
        }
    }
}

