/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtjsonrpc.server;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RPCServletUtils {
    public static boolean acceptsGzipEncoding(HttpServletRequest request) {
        String accepts = request.getHeader("Accept-Encoding");
        return accepts != null && accepts.indexOf("gzip") != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeResponse(ServletContext ctx, HttpServletResponse res, String responseContent, boolean encodeWithGzip) throws IOException {
        byte[] data = responseContent.getBytes("UTF-8");
        if (encodeWithGzip) {
            ByteArrayOutputStream buf = new ByteArrayOutputStream(data.length);
            try (GZIPOutputStream gz = new GZIPOutputStream(buf);){
                gz.write(data);
                gz.finish();
                gz.flush();
                res.setHeader("Content-Encoding", "gzip");
                data = buf.toByteArray();
            }
        }
        res.setContentLength(data.length);
        res.setContentType("application/json; charset=utf-8");
        res.setStatus(200);
        res.setHeader("Content-Disposition", "attachment");
        res.getOutputStream().write(data);
    }

    private RPCServletUtils() {
    }
}

