/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtjsonrpc.server;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.sql.Date;

public class SqlDateDeserializer
implements JsonDeserializer<Date>,
JsonSerializer<Date> {
    @Override
    public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (json.isJsonNull()) {
            return null;
        }
        if (!json.isJsonPrimitive()) {
            throw new JsonParseException("Expected string for date type");
        }
        JsonPrimitive p = (JsonPrimitive)json;
        if (!p.isString()) {
            throw new JsonParseException("Expected string for date type");
        }
        try {
            return Date.valueOf(p.getAsString());
        }
        catch (IllegalArgumentException e) {
            throw new JsonParseException("Not a date string");
        }
    }

    @Override
    public JsonElement serialize(Date src, Type typeOfSrc, JsonSerializationContext context) {
        if (src == null) {
            return new JsonNull();
        }
        return new JsonPrimitive(src.toString());
    }
}

