/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtorm.jdbc;

import java.io.File;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class SimpleDataSource
implements DataSource {
    private final Properties connectionInfo = new Properties();
    private final String url;
    private final Driver driver;
    private PrintWriter logWriter;

    public SimpleDataSource(Properties dbInfo) throws SQLException {
        this.connectionInfo.putAll((Map<?, ?>)dbInfo);
        this.url = (String)this.connectionInfo.remove("url");
        if (this.url == null) {
            throw new SQLException("Required property 'url' not defined");
        }
        String driverName = (String)this.connectionInfo.remove("driver");
        String classpath = (String)this.connectionInfo.remove("classpath");
        if (driverName != null) {
            ClassLoader cl = SimpleDataSource.threadCL();
            if (classpath != null && classpath.length() > 0) {
                ArrayList<URL> urls = new ArrayList<URL>();
                for (String path : classpath.split(File.pathSeparator)) {
                    try {
                        urls.add(new URL(path));
                    }
                    catch (MalformedURLException e1) {
                        File f = new File(path);
                        if (f.exists()) {
                            try {
                                urls.add(f.getAbsoluteFile().toURI().toURL());
                                continue;
                            }
                            catch (MalformedURLException e2) {
                                throw SimpleDataSource.badClasspath(classpath, e2);
                            }
                        }
                        throw SimpleDataSource.badClasspath(classpath, e1);
                    }
                }
                cl = new URLClassLoader(urls.toArray(new URL[urls.size()]), cl);
            }
            this.driver = SimpleDataSource.loadDriver(driverName, cl);
        } else {
            this.driver = null;
        }
        this.logWriter = new PrintWriter(System.out);
    }

    private static SQLException badClasspath(String classpath, MalformedURLException e1) {
        SQLException sqle = new SQLException("Invalid driver classpath " + classpath);
        sqle.initCause(e1);
        return sqle;
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.driver != null) {
            return this.driver.connect(this.url, this.connectionInfo);
        }
        return DriverManager.getConnection(this.url, this.connectionInfo);
    }

    @Override
    public Connection getConnection(String user, String password) throws SQLException {
        if (this.driver != null) {
            Properties info = new Properties(this.connectionInfo);
            if (user != null) {
                info.put("user", user);
            }
            if (password != null) {
                info.put("password", password);
            }
            return this.driver.connect(this.url, info);
        }
        return DriverManager.getConnection(this.url, user, password);
    }

    @Override
    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    @Override
    public void setLogWriter(PrintWriter out) {
        this.logWriter = out;
    }

    @Override
    public int getLoginTimeout() {
        return 0;
    }

    @Override
    public void setLoginTimeout(int seconds) {
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException(this.getClass().getName() + " wraps nothing");
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    private static synchronized Driver loadDriver(String driver, ClassLoader loader) throws SQLException {
        try {
            return (Driver)Class.forName(driver, true, loader).newInstance();
        }
        catch (Throwable err) {
            SQLException e = new SQLException("Driver class " + driver + " not available");
            e.initCause(err);
            throw e;
        }
    }

    private static ClassLoader threadCL() {
        try {
            return Thread.currentThread().getContextClassLoader();
        }
        catch (SecurityException e) {
            return SimpleDataSource.class.getClassLoader();
        }
    }
}

