/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtorm.nosql;

import com.google.gwtorm.protobuf.ProtobufCodec;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.WireFormat;
import java.io.EOFException;
import java.io.IOException;

public class RelationCodec<T>
extends ProtobufCodec<T> {
    private final int fieldId;
    private final ProtobufCodec<T> objectCodec;

    public static int peekId(CodedInputStream in) throws IOException {
        return in.readTag() >>> 3;
    }

    public RelationCodec(int fieldId, ProtobufCodec<T> objectCodec) {
        this.fieldId = fieldId;
        this.objectCodec = objectCodec;
    }

    @Override
    public T newInstance() {
        return this.objectCodec.newInstance();
    }

    @Override
    public int sizeof(T obj) {
        int sz = this.objectCodec.sizeof(obj);
        return CodedOutputStream.computeTagSize(this.fieldId) + CodedOutputStream.computeRawVarint32Size(sz) + sz;
    }

    @Override
    public void encode(T obj, CodedOutputStream out) throws IOException {
        int sz = this.objectCodec.sizeof(obj);
        out.writeTag(this.fieldId, WireFormat.FieldType.MESSAGE.getWireType());
        out.writeRawVarint32(sz);
        this.objectCodec.encode(obj, out);
    }

    @Override
    public void mergeFrom(CodedInputStream in, T obj) throws IOException {
        boolean found = false;
        while (true) {
            int tag;
            if ((tag = in.readTag()) == 0) {
                if (found) break;
                throw new EOFException("Expected field " + this.fieldId);
            }
            if (tag >>> 3 == this.fieldId) {
                if ((tag & 7) == WireFormat.FieldType.MESSAGE.getWireType()) {
                    int sz = in.readRawVarint32();
                    int oldLimit = in.pushLimit(sz);
                    this.objectCodec.mergeFrom(in, obj);
                    in.checkLastTagWas(0);
                    in.popLimit(oldLimit);
                    found = true;
                    continue;
                }
                throw new InvalidProtocolBufferException("Field " + this.fieldId + " should be length delimited (wire type 2)");
            }
            in.skipField(tag);
        }
    }
}

