/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtorm.protobuf;

import java.io.IOException;
import java.io.InputStream;

class CappedInputStream
extends InputStream {
    private final InputStream src;
    private int remaining;

    CappedInputStream(InputStream src, int limit) {
        this.src = src;
        this.remaining = limit;
    }

    @Override
    public int read() throws IOException {
        if (0 < this.remaining) {
            int r = this.src.read();
            this.remaining = r < 0 ? 0 : --this.remaining;
            return r;
        }
        return -1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        if (0 < this.remaining) {
            int n = this.src.read(b, off, Math.min(len, this.remaining));
            this.remaining = n < 0 ? 0 : (this.remaining -= n);
            return n;
        }
        return -1;
    }

    @Override
    public void close() throws IOException {
        this.remaining = 0;
        this.src.close();
    }
}

