/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtorm.protobuf;

import com.google.gwtorm.client.Column;
import com.google.gwtorm.protobuf.CodecFactory;
import com.google.gwtorm.protobuf.CustomCodec;
import com.google.gwtorm.protobuf.ProtobufCodec;
import com.google.gwtorm.schema.ColumnModel;
import com.google.gwtorm.schema.Util;
import com.google.gwtorm.schema.java.JavaColumnModel;
import com.google.gwtorm.server.CodeGenSupport;
import com.google.gwtorm.server.GeneratedClassLoader;
import com.google.gwtorm.server.OrmException;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.WireFormat;
import java.lang.reflect.Field;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

class CodecGen<T>
implements Opcodes {
    private static final Type illegalStateException = Type.getType(IllegalStateException.class);
    private static final Type collection = Type.getType(Collection.class);
    private static final Type iterator = Type.getType(Iterator.class);
    private static final Type string = Type.getType(String.class);
    private static final Type enumType = Type.getType(Enum.class);
    private static final Type byteString = Type.getType(ByteString.class);
    private static final Type object = Type.getType(Object.class);
    private static final Type codedOutputStream = Type.getType(CodedOutputStream.class);
    private static final Type codedInputStream = Type.getType(CodedInputStream.class);
    private final GeneratedClassLoader classLoader;
    private final Class<T> pojo;
    private final Type pojoType;
    private ClassWriter cw;
    private JavaColumnModel[] myFields;
    private String superTypeName;
    private String implClassName;
    private String implTypeName;
    private Map<Class<?>, NestedCodec> nestedCodecs;

    public CodecGen(GeneratedClassLoader loader, Class<T> t) {
        this.classLoader = loader;
        this.pojo = t;
        this.pojoType = Type.getType(this.pojo);
        this.nestedCodecs = new HashMap();
    }

    public ProtobufCodec<T> create() throws OrmException {
        this.myFields = CodecGen.scanFields(this.pojo);
        this.init();
        this.implementNewInstanceObject();
        this.implementNewInstanceSelf();
        this.implementSizeofObject();
        this.implementSizeofSelf();
        this.implementEncodeObject();
        this.implementEncodeSelf();
        this.implementMergeFromObject();
        this.implementMergeFromSelf();
        this.implementCodecFields();
        this.implementStaticInit();
        this.implementConstructor();
        this.cw.visitEnd();
        this.classLoader.defineClass(this.implClassName, this.cw.toByteArray());
        try {
            Class<?> c = Class.forName(this.implClassName, true, this.classLoader);
            return CodecGen.cast(c.newInstance());
        }
        catch (InstantiationException e) {
            throw new OrmException("Cannot create new encoder", e);
        }
        catch (IllegalAccessException e) {
            throw new OrmException("Cannot create new encoder", e);
        }
        catch (ClassNotFoundException e) {
            throw new OrmException("Cannot create new encoder", e);
        }
    }

    private static JavaColumnModel[] scanFields(Class<?> in) throws OrmException {
        ArrayList<JavaColumnModel> col = new ArrayList<JavaColumnModel>();
        while (in != null) {
            for (Field f : JavaColumnModel.getDeclaredFields(in)) {
                if (f.getAnnotation(Column.class) == null) continue;
                col.add(new JavaColumnModel(f));
            }
            in = in.getSuperclass();
        }
        if (col.isEmpty()) {
            throw new OrmException("Cannot create new encoder, no @Column fields found");
        }
        return CodecGen.sort(col);
    }

    private static JavaColumnModel[] sort(Collection<? extends ColumnModel> col) {
        JavaColumnModel[] out = col.toArray(new JavaColumnModel[col.size()]);
        Arrays.sort(out, new Comparator<JavaColumnModel>(){

            @Override
            public int compare(JavaColumnModel o1, JavaColumnModel o2) {
                return o1.getColumnID() - o2.getColumnID();
            }
        });
        return out;
    }

    private static <T> ProtobufCodec<T> cast(Object c) {
        return (ProtobufCodec)c;
    }

    private void init() {
        this.superTypeName = Type.getInternalName(ProtobufCodec.class);
        this.implClassName = this.pojo.getName() + "_protobuf_" + Util.createRandomName();
        this.implTypeName = this.implClassName.replace('.', '/');
        this.cw = new ClassWriter(1);
        this.cw.visit(47, 49, this.implTypeName, null, this.superTypeName, new String[0]);
    }

    private void implementCodecFields() {
        for (NestedCodec other : this.nestedCodecs.values()) {
            this.cw.visitField(26, other.field, other.codecType.getDescriptor(), null, null).visitEnd();
        }
    }

    private void implementStaticInit() {
        MethodVisitor mv = this.cw.visitMethod(9, "<clinit>", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[0]), null, null);
        mv.visitCode();
        for (NestedCodec other : this.nestedCodecs.values()) {
            mv.visitTypeInsn(187, other.codecType.getInternalName());
            mv.visitInsn(89);
            mv.visitMethodInsn(183, other.codecType.getInternalName(), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[0]));
            mv.visitFieldInsn(179, this.implTypeName, other.field, other.codecType.getDescriptor());
        }
        mv.visitInsn(177);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    private void implementConstructor() {
        String consName = "<init>";
        String consDesc = Type.getMethodDescriptor(Type.VOID_TYPE, new Type[0]);
        MethodVisitor mv = this.cw.visitMethod(1, "<init>", consDesc, null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, this.superTypeName, "<init>", consDesc);
        mv.visitInsn(177);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    private void implementNewInstanceObject() {
        MethodVisitor mv = this.cw.visitMethod(1, "newInstance", Type.getMethodDescriptor(object, new Type[0]), null, new String[0]);
        mv.visitCode();
        mv.visitTypeInsn(187, this.pojoType.getInternalName());
        mv.visitInsn(89);
        mv.visitMethodInsn(183, this.pojoType.getInternalName(), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[0]));
        mv.visitInsn(176);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    private void implementNewInstanceSelf() {
        MethodVisitor mv = this.cw.visitMethod(1, "newInstance", Type.getMethodDescriptor(this.pojoType, new Type[0]), null, new String[0]);
        mv.visitCode();
        mv.visitTypeInsn(187, this.pojoType.getInternalName());
        mv.visitInsn(89);
        mv.visitMethodInsn(183, this.pojoType.getInternalName(), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[0]));
        mv.visitInsn(176);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    private void implementSizeofObject() {
        MethodVisitor mv = this.cw.visitMethod(1, "sizeof", Type.getMethodDescriptor(Type.INT_TYPE, object), null, new String[0]);
        mv.visitCode();
        SizeofCGS cgs = new SizeofCGS(mv);
        cgs.sizeVar = cgs.newLocal();
        cgs.setEntityType(this.pojoType);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, this.pojoType.getInternalName());
        mv.visitMethodInsn(182, this.implTypeName, "sizeof", Type.getMethodDescriptor(Type.INT_TYPE, this.pojoType));
        mv.visitInsn(172);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    private void implementSizeofSelf() throws OrmException {
        MethodVisitor mv = this.cw.visitMethod(1, "sizeof", Type.getMethodDescriptor(Type.INT_TYPE, this.pojoType), null, new String[0]);
        mv.visitCode();
        SizeofCGS cgs = new SizeofCGS(mv);
        cgs.sizeVar = cgs.newLocal();
        cgs.setEntityType(this.pojoType);
        cgs.push(0);
        mv.visitVarInsn(54, cgs.sizeVar);
        this.sizeofMessage(this.myFields, mv, cgs);
        mv.visitVarInsn(21, cgs.sizeVar);
        mv.visitInsn(172);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    private void sizeofMessage(JavaColumnModel[] myFields, MethodVisitor mv, SizeofCGS cgs) throws OrmException {
        for (JavaColumnModel f : myFields) {
            if (f.isNested()) {
                NestedCodec n = this.nestedFor(f);
                Label end = new Label();
                cgs.setFieldReference(f);
                cgs.pushFieldValue();
                mv.visitJumpInsn(198, end);
                int msgSizeVar = cgs.newLocal();
                mv.visitFieldInsn(178, this.implTypeName, n.field, n.codecType.getDescriptor());
                cgs.pushFieldValue();
                mv.visitMethodInsn(182, n.codecType.getInternalName(), "sizeof", Type.getMethodDescriptor(Type.INT_TYPE, n.pojoType));
                mv.visitVarInsn(54, msgSizeVar);
                cgs.preinc();
                cgs.push(f.getColumnID());
                cgs.doinc("computeTagSize", Type.INT_TYPE);
                cgs.preinc();
                mv.visitVarInsn(21, msgSizeVar);
                cgs.doinc("computeRawVarint32Size", Type.INT_TYPE);
                cgs.preinc();
                mv.visitVarInsn(21, msgSizeVar);
                cgs.doinc();
                cgs.freeLocal(msgSizeVar);
                mv.visitLabel(end);
                continue;
            }
            if (f.isCollection()) {
                this.sizeofCollection(f, mv, cgs);
                continue;
            }
            this.sizeofScalar(mv, cgs, f);
        }
    }

    private NestedCodec nestedFor(JavaColumnModel f) {
        Class<?> clazz = f.getNestedClass();
        NestedCodec n = this.nestedCodecs.get(clazz);
        if (n == null) {
            CustomCodec cc;
            Class<Object> codec = null;
            Type type = Type.getType(clazz);
            if (f.getField() != null && (cc = f.getField().getAnnotation(CustomCodec.class)) != null) {
                codec = cc.value();
                type = object;
            }
            if (codec == null) {
                codec = CodecFactory.encoder(clazz).getClass();
            }
            n = new NestedCodec("codec" + f.getColumnID(), codec, type);
            this.nestedCodecs.put(clazz, n);
        }
        return n;
    }

    private void sizeofCollection(JavaColumnModel f, MethodVisitor mv, final SizeofCGS cgs) throws OrmException {
        int itr = cgs.newLocal();
        final int val = cgs.newLocal();
        Class valClazz = (Class)f.getArgumentTypes()[0];
        final Type valType = Type.getType(valClazz);
        final JavaColumnModel col = this.collectionColumn(f, valClazz);
        SizeofCGS ng = new SizeofCGS(mv){
            {
                super(x0);
                this.sizeVar = cgs.sizeVar;
                this.setEntityType(valType);
            }

            @Override
            public void pushEntity() {
                this.mv.visitVarInsn(25, val);
            }

            @Override
            protected void appendGetField(ColumnModel c) {
                if (c != col) {
                    super.appendGetField(c);
                }
            }

            @Override
            public int newLocal() {
                return cgs.newLocal();
            }

            @Override
            public void freeLocal(int index) {
                cgs.freeLocal(index);
            }
        };
        Label end = new Label();
        cgs.setFieldReference(f);
        cgs.pushFieldValue();
        mv.visitJumpInsn(198, end);
        cgs.setFieldReference(f);
        cgs.pushFieldValue();
        mv.visitMethodInsn(185, collection.getInternalName(), "iterator", Type.getMethodDescriptor(iterator, new Type[0]));
        mv.visitVarInsn(58, itr);
        Label doloop = new Label();
        mv.visitLabel(doloop);
        mv.visitVarInsn(25, itr);
        mv.visitMethodInsn(185, iterator.getInternalName(), "hasNext", Type.getMethodDescriptor(Type.BOOLEAN_TYPE, new Type[0]));
        mv.visitJumpInsn(153, end);
        mv.visitVarInsn(25, itr);
        mv.visitMethodInsn(185, iterator.getInternalName(), "next", Type.getMethodDescriptor(object, new Type[0]));
        mv.visitTypeInsn(192, valType.getInternalName());
        mv.visitVarInsn(58, val);
        this.sizeofMessage(new JavaColumnModel[]{col}, mv, ng);
        mv.visitJumpInsn(167, doloop);
        mv.visitLabel(end);
        cgs.freeLocal(itr);
        cgs.freeLocal(val);
    }

    private JavaColumnModel collectionColumn(JavaColumnModel f, Class<?> valClazz) throws OrmException {
        return new JavaColumnModel(f.getField(), f.getPathToFieldName(), f.getColumnID(), valClazz);
    }

    private void sizeofScalar(MethodVisitor mv, SizeofCGS cgs, JavaColumnModel f) throws OrmException {
        cgs.setFieldReference(f);
        switch (Type.getType(f.getPrimitiveType()).getSort()) {
            case 1: {
                cgs.preinc();
                cgs.push(f.getColumnID());
                cgs.pushFieldValue();
                cgs.doinc("computeBoolSize", Type.INT_TYPE, Type.BOOLEAN_TYPE);
                break;
            }
            case 2: {
                cgs.preinc();
                cgs.push(f.getColumnID());
                cgs.pushFieldValue();
                cgs.doinc("computeUInt32Size", Type.INT_TYPE, Type.INT_TYPE);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                cgs.preinc();
                cgs.push(f.getColumnID());
                cgs.pushFieldValue();
                cgs.doinc("computeInt32Size", Type.INT_TYPE, Type.INT_TYPE);
                break;
            }
            case 6: {
                cgs.preinc();
                cgs.push(f.getColumnID());
                cgs.pushFieldValue();
                cgs.doinc("computeFloatSize", Type.INT_TYPE, Type.FLOAT_TYPE);
                break;
            }
            case 8: {
                cgs.preinc();
                cgs.push(f.getColumnID());
                cgs.pushFieldValue();
                cgs.doinc("computeDoubleSize", Type.INT_TYPE, Type.DOUBLE_TYPE);
                break;
            }
            case 7: {
                cgs.preinc();
                cgs.push(f.getColumnID());
                cgs.pushFieldValue();
                cgs.doinc("computeInt64Size", Type.INT_TYPE, Type.LONG_TYPE);
                break;
            }
            case 9: 
            case 10: {
                Label end = new Label();
                cgs.pushFieldValue();
                mv.visitJumpInsn(198, end);
                if (f.getPrimitiveType() == byte[].class) {
                    cgs.preinc();
                    cgs.push(f.getColumnID());
                    cgs.doinc("computeTagSize", Type.INT_TYPE);
                    cgs.preinc();
                    cgs.pushFieldValue();
                    mv.visitInsn(190);
                    cgs.doinc("computeRawVarint32Size", Type.INT_TYPE);
                    cgs.preinc();
                    cgs.pushFieldValue();
                    mv.visitInsn(190);
                    cgs.doinc();
                } else if (f.getPrimitiveType() == String.class) {
                    cgs.preinc();
                    cgs.push(f.getColumnID());
                    cgs.pushFieldValue();
                    cgs.doinc("computeStringSize", Type.INT_TYPE, string);
                } else if (f.getPrimitiveType() == Timestamp.class || f.getPrimitiveType() == java.util.Date.class || f.getPrimitiveType() == Date.class) {
                    cgs.preinc();
                    cgs.push(f.getColumnID());
                    cgs.pushFieldValue();
                    String tsType = Type.getType(f.getPrimitiveType()).getInternalName();
                    mv.visitMethodInsn(182, tsType, "getTime", Type.getMethodDescriptor(Type.LONG_TYPE, new Type[0]));
                    cgs.doinc("computeFixed64Size", Type.INT_TYPE, Type.LONG_TYPE);
                } else if (f.getPrimitiveType().isEnum()) {
                    cgs.preinc();
                    cgs.push(f.getColumnID());
                    cgs.pushFieldValue();
                    mv.visitMethodInsn(182, enumType.getInternalName(), "ordinal", Type.getMethodDescriptor(Type.INT_TYPE, new Type[0]));
                    cgs.doinc("computeEnumSize", Type.INT_TYPE, Type.INT_TYPE);
                } else {
                    throw new OrmException("Type " + f.getPrimitiveType() + " not supported for field " + f.getPathToFieldName());
                }
                mv.visitLabel(end);
                break;
            }
            default: {
                throw new OrmException("Type " + f.getPrimitiveType() + " not supported for field " + f.getPathToFieldName());
            }
        }
    }

    private void implementEncodeObject() {
        MethodVisitor mv = this.cw.visitMethod(1, "encode", Type.getMethodDescriptor(Type.VOID_TYPE, object, codedOutputStream), null, new String[0]);
        mv.visitCode();
        EncodeCGS cgs = new EncodeCGS(mv);
        cgs.setEntityType(this.pojoType);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, this.pojoType.getInternalName());
        mv.visitVarInsn(25, 2);
        mv.visitMethodInsn(182, this.implTypeName, "encode", Type.getMethodDescriptor(Type.VOID_TYPE, this.pojoType, codedOutputStream));
        mv.visitInsn(177);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    private void implementEncodeSelf() throws OrmException {
        MethodVisitor mv = this.cw.visitMethod(1, "encode", Type.getMethodDescriptor(Type.VOID_TYPE, this.pojoType, codedOutputStream), null, new String[0]);
        mv.visitCode();
        EncodeCGS cgs = new EncodeCGS(mv);
        cgs.setEntityType(this.pojoType);
        this.encodeMessage(this.myFields, mv, cgs);
        mv.visitInsn(177);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    private void encodeMessage(JavaColumnModel[] myFields, MethodVisitor mv, EncodeCGS cgs) throws OrmException {
        for (JavaColumnModel f : myFields) {
            if (f.isNested()) {
                NestedCodec n = this.nestedFor(f);
                Label end = new Label();
                cgs.setFieldReference(f);
                cgs.pushFieldValue();
                mv.visitJumpInsn(198, end);
                int msgSizeVar = cgs.newLocal();
                mv.visitFieldInsn(178, this.implTypeName, n.field, n.codecType.getDescriptor());
                cgs.pushFieldValue();
                mv.visitMethodInsn(182, n.codecType.getInternalName(), "sizeof", Type.getMethodDescriptor(Type.INT_TYPE, n.pojoType));
                mv.visitVarInsn(54, msgSizeVar);
                cgs.pushCodedOutputStream();
                cgs.push(f.getColumnID());
                cgs.push(WireFormat.FieldType.MESSAGE.getWireType());
                mv.visitMethodInsn(182, codedOutputStream.getInternalName(), "writeTag", Type.getMethodDescriptor(Type.VOID_TYPE, Type.INT_TYPE, Type.INT_TYPE));
                cgs.pushCodedOutputStream();
                mv.visitVarInsn(21, msgSizeVar);
                mv.visitMethodInsn(182, codedOutputStream.getInternalName(), "writeRawVarint32", Type.getMethodDescriptor(Type.VOID_TYPE, Type.INT_TYPE));
                mv.visitFieldInsn(178, this.implTypeName, n.field, n.codecType.getDescriptor());
                cgs.pushFieldValue();
                cgs.pushCodedOutputStream();
                mv.visitMethodInsn(182, n.codecType.getInternalName(), "encode", Type.getMethodDescriptor(Type.VOID_TYPE, n.pojoType, codedOutputStream));
                cgs.freeLocal(msgSizeVar);
                mv.visitLabel(end);
                continue;
            }
            if (f.isCollection()) {
                this.encodeCollection(f, mv, cgs);
                continue;
            }
            this.encodeScalar(mv, cgs, f);
        }
    }

    private void encodeCollection(JavaColumnModel f, MethodVisitor mv, final EncodeCGS cgs) throws OrmException {
        int itr = cgs.newLocal();
        final int val = cgs.newLocal();
        Class valClazz = (Class)f.getArgumentTypes()[0];
        final Type valType = Type.getType(valClazz);
        final JavaColumnModel col = this.collectionColumn(f, valClazz);
        EncodeCGS ng = new EncodeCGS(mv){
            {
                super(x0);
                this.sizeVar = cgs.sizeVar;
                this.setEntityType(valType);
            }

            @Override
            public void pushEntity() {
                this.mv.visitVarInsn(25, val);
            }

            @Override
            protected void appendGetField(ColumnModel c) {
                if (c != col) {
                    super.appendGetField(c);
                }
            }

            @Override
            public int newLocal() {
                return cgs.newLocal();
            }

            @Override
            public void freeLocal(int index) {
                cgs.freeLocal(index);
            }
        };
        Label end = new Label();
        cgs.setFieldReference(f);
        cgs.pushFieldValue();
        mv.visitJumpInsn(198, end);
        cgs.setFieldReference(f);
        cgs.pushFieldValue();
        mv.visitMethodInsn(185, collection.getInternalName(), "iterator", Type.getMethodDescriptor(iterator, new Type[0]));
        mv.visitVarInsn(58, itr);
        Label doloop = new Label();
        mv.visitLabel(doloop);
        mv.visitVarInsn(25, itr);
        mv.visitMethodInsn(185, iterator.getInternalName(), "hasNext", Type.getMethodDescriptor(Type.BOOLEAN_TYPE, new Type[0]));
        mv.visitJumpInsn(153, end);
        mv.visitVarInsn(25, itr);
        mv.visitMethodInsn(185, iterator.getInternalName(), "next", Type.getMethodDescriptor(object, new Type[0]));
        mv.visitTypeInsn(192, valType.getInternalName());
        mv.visitVarInsn(58, val);
        this.encodeMessage(new JavaColumnModel[]{col}, mv, ng);
        mv.visitJumpInsn(167, doloop);
        mv.visitLabel(end);
        cgs.freeLocal(itr);
        cgs.freeLocal(val);
    }

    private void encodeScalar(MethodVisitor mv, EncodeCGS cgs, JavaColumnModel f) throws OrmException {
        cgs.setFieldReference(f);
        switch (Type.getType(f.getPrimitiveType()).getSort()) {
            case 1: {
                cgs.pushCodedOutputStream();
                cgs.push(f.getColumnID());
                cgs.pushFieldValue();
                cgs.write("writeBool", Type.BOOLEAN_TYPE);
                break;
            }
            case 2: {
                cgs.pushCodedOutputStream();
                cgs.push(f.getColumnID());
                cgs.pushFieldValue();
                cgs.write("writeUInt32", Type.INT_TYPE);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                cgs.pushCodedOutputStream();
                cgs.push(f.getColumnID());
                cgs.pushFieldValue();
                cgs.write("writeInt32", Type.INT_TYPE);
                break;
            }
            case 6: {
                cgs.pushCodedOutputStream();
                cgs.push(f.getColumnID());
                cgs.pushFieldValue();
                cgs.write("writeFloat", Type.FLOAT_TYPE);
                break;
            }
            case 8: {
                cgs.pushCodedOutputStream();
                cgs.push(f.getColumnID());
                cgs.pushFieldValue();
                cgs.write("writeDouble", Type.DOUBLE_TYPE);
                break;
            }
            case 7: {
                cgs.pushCodedOutputStream();
                cgs.push(f.getColumnID());
                cgs.pushFieldValue();
                cgs.write("writeInt64", Type.LONG_TYPE);
                break;
            }
            case 9: 
            case 10: {
                Label end = new Label();
                cgs.pushFieldValue();
                mv.visitJumpInsn(198, end);
                if (f.getPrimitiveType() == byte[].class) {
                    cgs.pushCodedOutputStream();
                    cgs.push(f.getColumnID());
                    cgs.push(WireFormat.FieldType.BYTES.getWireType());
                    mv.visitMethodInsn(182, codedOutputStream.getInternalName(), "writeTag", Type.getMethodDescriptor(Type.VOID_TYPE, Type.INT_TYPE, Type.INT_TYPE));
                    cgs.pushCodedOutputStream();
                    cgs.pushFieldValue();
                    mv.visitInsn(190);
                    mv.visitMethodInsn(182, codedOutputStream.getInternalName(), "writeRawVarint32", Type.getMethodDescriptor(Type.VOID_TYPE, Type.INT_TYPE));
                    cgs.pushCodedOutputStream();
                    cgs.pushFieldValue();
                    mv.visitMethodInsn(182, codedOutputStream.getInternalName(), "writeRawBytes", Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(byte[].class)));
                } else {
                    cgs.pushCodedOutputStream();
                    cgs.push(f.getColumnID());
                    cgs.pushFieldValue();
                    if (f.getPrimitiveType() == String.class) {
                        cgs.write("writeString", string);
                    } else if (f.getPrimitiveType() == Timestamp.class || f.getPrimitiveType() == java.util.Date.class || f.getPrimitiveType() == Date.class) {
                        String tsType = Type.getType(f.getPrimitiveType()).getInternalName();
                        mv.visitMethodInsn(182, tsType, "getTime", Type.getMethodDescriptor(Type.LONG_TYPE, new Type[0]));
                        cgs.write("writeFixed64", Type.LONG_TYPE);
                    } else if (f.getPrimitiveType().isEnum()) {
                        mv.visitMethodInsn(182, enumType.getInternalName(), "ordinal", Type.getMethodDescriptor(Type.INT_TYPE, new Type[0]));
                        cgs.write("writeEnum", Type.INT_TYPE);
                    } else {
                        throw new OrmException("Type " + f.getPrimitiveType() + " not supported for field " + f.getPathToFieldName());
                    }
                }
                mv.visitLabel(end);
                break;
            }
            default: {
                throw new OrmException("Type " + f.getPrimitiveType() + " not supported for field " + f.getPathToFieldName());
            }
        }
    }

    private void implementMergeFromObject() {
        MethodVisitor mv = this.cw.visitMethod(1, "mergeFrom", Type.getMethodDescriptor(Type.VOID_TYPE, codedInputStream, object), null, new String[0]);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitTypeInsn(192, this.pojoType.getInternalName());
        mv.visitMethodInsn(182, this.implTypeName, "mergeFrom", Type.getMethodDescriptor(Type.VOID_TYPE, codedInputStream, this.pojoType));
        mv.visitInsn(177);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    private void implementMergeFromSelf() throws OrmException {
        MethodVisitor mv = this.cw.visitMethod(1, "mergeFrom", Type.getMethodDescriptor(Type.VOID_TYPE, codedInputStream, this.pojoType), null, new String[0]);
        mv.visitCode();
        DecodeCGS cgs = new DecodeCGS(mv);
        cgs.objVar = 2;
        cgs.tagVar = cgs.newLocal();
        cgs.setEntityType(this.pojoType);
        this.decodeMessage(this.myFields, mv, cgs);
        mv.visitInsn(177);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    private void decodeMessage(JavaColumnModel[] myFields, MethodVisitor mv, DecodeCGS cgs) throws OrmException {
        Label nextField = new Label();
        Label end = new Label();
        mv.visitLabel(nextField);
        cgs.call("readTag", Type.INT_TYPE);
        mv.visitInsn(89);
        mv.visitVarInsn(54, cgs.tagVar);
        cgs.push(3);
        mv.visitInsn(124);
        Label badField = new Label();
        int[] caseTags = new int[1 + myFields.length];
        Label[] caseLabels = new Label[caseTags.length];
        caseTags[0] = 0;
        caseLabels[0] = new Label();
        int gaps = 0;
        for (int i = 1; i < caseTags.length; ++i) {
            caseTags[i] = myFields[i - 1].getColumnID();
            caseLabels[i] = new Label();
            gaps += caseTags[i] - (caseTags[i - 1] + 1);
        }
        if (2 * gaps / 3 <= myFields.length) {
            boolean min = false;
            int max = caseTags[caseTags.length - 1];
            Object[] table = new Label[max + 1];
            Arrays.fill(table, badField);
            for (int idx = 0; idx < caseTags.length; ++idx) {
                table[caseTags[idx]] = caseLabels[idx];
            }
            mv.visitTableSwitchInsn(0, max, badField, (Label[])table);
        } else {
            mv.visitLookupSwitchInsn(badField, caseTags, caseLabels);
        }
        mv.visitLabel(caseLabels[0]);
        mv.visitJumpInsn(167, end);
        for (int idx = 1; idx < caseTags.length; ++idx) {
            JavaColumnModel f = myFields[idx - 1];
            mv.visitLabel(caseLabels[idx]);
            this.decodeField(mv, cgs, f);
            mv.visitJumpInsn(167, nextField);
        }
        mv.visitLabel(badField);
        cgs.pushCodedInputStream();
        mv.visitVarInsn(21, cgs.tagVar);
        cgs.ncallInt("skipField", Type.BOOLEAN_TYPE);
        mv.visitInsn(87);
        mv.visitJumpInsn(167, nextField);
        mv.visitLabel(end);
        cgs.pushCodedInputStream();
        cgs.push(0);
        cgs.ncallInt("checkLastTagWas", Type.VOID_TYPE);
    }

    private void decodeField(MethodVisitor mv, DecodeCGS cgs, JavaColumnModel f) throws OrmException {
        if (f.isNested()) {
            NestedCodec n = this.nestedFor(f);
            Label load = new Label();
            cgs.setFieldReference(f);
            cgs.pushFieldValue();
            mv.visitJumpInsn(199, load);
            cgs.fieldSetBegin();
            mv.visitFieldInsn(178, this.implTypeName, n.field, n.codecType.getDescriptor());
            mv.visitMethodInsn(182, n.codecType.getInternalName(), "newInstance", Type.getMethodDescriptor(n.pojoType, new Type[0]));
            if (object.equals(n.pojoType)) {
                mv.visitTypeInsn(192, Type.getType(f.getNestedClass()).getInternalName());
            }
            cgs.fieldSetEnd();
            mv.visitLabel(load);
            int limitVar = cgs.newLocal();
            cgs.pushCodedInputStream();
            cgs.call("readRawVarint32", Type.INT_TYPE);
            cgs.ncallInt("pushLimit", Type.INT_TYPE);
            mv.visitVarInsn(54, limitVar);
            mv.visitFieldInsn(178, this.implTypeName, n.field, n.codecType.getDescriptor());
            cgs.pushCodedInputStream();
            cgs.pushFieldValue();
            mv.visitMethodInsn(182, n.codecType.getInternalName(), "mergeFrom", Type.getMethodDescriptor(Type.VOID_TYPE, codedInputStream, n.pojoType));
            cgs.pushCodedInputStream();
            mv.visitVarInsn(21, limitVar);
            cgs.ncallInt("popLimit", Type.VOID_TYPE);
            cgs.freeLocal(limitVar);
        } else if (f.isCollection()) {
            this.decodeCollection(mv, cgs, f);
        } else {
            CodecGen.decodeScalar(mv, cgs, f);
        }
    }

    private void decodeCollection(MethodVisitor mv, final DecodeCGS cgs, JavaColumnModel f) throws OrmException {
        Type concreteType;
        Class valClazz = (Class)f.getArgumentTypes()[0];
        final Type valType = Type.getType(valClazz);
        final JavaColumnModel col = this.collectionColumn(f, valClazz);
        DecodeCGS ng = new DecodeCGS(mv){
            {
                super(x0);
                this.tagVar = cgs.tagVar;
                this.setEntityType(valType);
            }

            @Override
            public int newLocal() {
                return cgs.newLocal();
            }

            @Override
            public void freeLocal(int index) {
                cgs.freeLocal(index);
            }

            @Override
            protected void appendGetField(ColumnModel c) {
                if (c != col) {
                    super.appendGetField(c);
                }
            }

            @Override
            public void fieldSetBegin() {
                if (col.isNested()) {
                    super.fieldSetBegin();
                } else {
                    cgs.pushFieldValue();
                }
            }

            @Override
            public void fieldSetEnd() {
                if (col.isNested()) {
                    super.fieldSetEnd();
                } else {
                    this.mv.visitMethodInsn(185, collection.getInternalName(), "add", Type.getMethodDescriptor(Type.BOOLEAN_TYPE, object));
                    this.mv.visitInsn(87);
                }
            }
        };
        Label notnull = new Label();
        cgs.setFieldReference(f);
        cgs.pushFieldValue();
        mv.visitJumpInsn(199, notnull);
        if (!f.getNestedClass().isInterface() && (f.getNestedClass().getModifiers() & 0x400) == 0) {
            concreteType = Type.getType(f.getNestedClass());
        } else if (f.getNestedClass().isAssignableFrom(ArrayList.class)) {
            concreteType = Type.getType(ArrayList.class);
        } else if (f.getNestedClass().isAssignableFrom(HashSet.class)) {
            concreteType = Type.getType(HashSet.class);
        } else if (f.getNestedClass().isAssignableFrom(TreeSet.class)) {
            concreteType = Type.getType(TreeSet.class);
        } else {
            mv.visitTypeInsn(187, illegalStateException.getInternalName());
            mv.visitInsn(89);
            mv.visitLdcInsn("Field " + f.getPathToFieldName() + " not initialized");
            mv.visitMethodInsn(183, illegalStateException.getInternalName(), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, string));
            mv.visitInsn(191);
            concreteType = null;
        }
        if (concreteType != null) {
            cgs.fieldSetBegin();
            mv.visitTypeInsn(187, concreteType.getInternalName());
            mv.visitInsn(89);
            mv.visitMethodInsn(183, concreteType.getInternalName(), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[0]));
            cgs.fieldSetEnd();
        }
        mv.visitLabel(notnull);
        if (col.isNested()) {
            NestedCodec n = this.nestedFor(col);
            ng.objVar = cgs.newLocal();
            mv.visitFieldInsn(178, this.implTypeName, n.field, n.codecType.getDescriptor());
            mv.visitMethodInsn(182, n.codecType.getInternalName(), "newInstance", Type.getMethodDescriptor(n.pojoType, new Type[0]));
            mv.visitVarInsn(58, ng.objVar);
            int limitVar = cgs.newLocal();
            cgs.pushCodedInputStream();
            cgs.call("readRawVarint32", Type.INT_TYPE);
            cgs.ncallInt("pushLimit", Type.INT_TYPE);
            mv.visitVarInsn(54, limitVar);
            mv.visitFieldInsn(178, this.implTypeName, n.field, n.codecType.getDescriptor());
            cgs.pushCodedInputStream();
            mv.visitVarInsn(25, ng.objVar);
            mv.visitMethodInsn(182, n.codecType.getInternalName(), "mergeFrom", Type.getMethodDescriptor(Type.VOID_TYPE, codedInputStream, n.pojoType));
            cgs.pushCodedInputStream();
            mv.visitVarInsn(21, limitVar);
            cgs.ncallInt("popLimit", Type.VOID_TYPE);
            cgs.freeLocal(limitVar);
            cgs.pushFieldValue();
            mv.visitVarInsn(25, ng.objVar);
            mv.visitMethodInsn(185, collection.getInternalName(), "add", Type.getMethodDescriptor(Type.BOOLEAN_TYPE, object));
            mv.visitInsn(87);
            cgs.freeLocal(ng.objVar);
        } else {
            if (col.isCollection()) {
                throw new OrmException("Cannot nest collection as member of another collection: " + f.getPathToFieldName());
            }
            CodecGen.decodeScalar(mv, ng, col);
        }
    }

    private static void decodeScalar(MethodVisitor mv, DecodeCGS cgs, JavaColumnModel f) throws OrmException {
        cgs.setFieldReference(f);
        cgs.fieldSetBegin();
        switch (Type.getType(f.getPrimitiveType()).getSort()) {
            case 1: {
                cgs.call("readBool", Type.BOOLEAN_TYPE);
                break;
            }
            case 2: {
                cgs.call("readUInt32", Type.INT_TYPE);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                cgs.call("readInt32", Type.INT_TYPE);
                break;
            }
            case 6: {
                cgs.call("readFloat", Type.FLOAT_TYPE);
                break;
            }
            case 8: {
                cgs.call("readDouble", Type.DOUBLE_TYPE);
                break;
            }
            case 7: {
                cgs.call("readInt64", Type.LONG_TYPE);
                break;
            }
            default: {
                if (f.getPrimitiveType() == byte[].class) {
                    cgs.call("readBytes", byteString);
                    mv.visitMethodInsn(182, byteString.getInternalName(), "toByteArray", Type.getMethodDescriptor(Type.getType(byte[].class), new Type[0]));
                    break;
                }
                if (f.getPrimitiveType() == String.class) {
                    cgs.call("readString", string);
                    break;
                }
                if (f.getPrimitiveType() == Timestamp.class || f.getPrimitiveType() == java.util.Date.class || f.getPrimitiveType() == Date.class) {
                    String tsType = Type.getType(f.getPrimitiveType()).getInternalName();
                    mv.visitTypeInsn(187, tsType);
                    mv.visitInsn(89);
                    cgs.call("readFixed64", Type.LONG_TYPE);
                    mv.visitMethodInsn(183, tsType, "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, Type.LONG_TYPE));
                    break;
                }
                if (f.getPrimitiveType().isEnum()) {
                    Type et = Type.getType(f.getPrimitiveType());
                    mv.visitMethodInsn(184, et.getInternalName(), "values", Type.getMethodDescriptor(Type.getType("[" + et.getDescriptor()), new Type[0]));
                    cgs.call("readEnum", Type.INT_TYPE);
                    mv.visitInsn(50);
                    break;
                }
                throw new OrmException("Type " + f.getPrimitiveType() + " not supported for field " + f.getPathToFieldName());
            }
        }
        cgs.fieldSetEnd();
    }

    private static class NestedCodec {
        final String field;
        final Type codecType;
        final Type pojoType;

        NestedCodec(String field, Class<?> impl, Type pojoType) {
            this.field = field;
            this.codecType = Type.getType(impl);
            this.pojoType = pojoType;
        }
    }

    private static class DecodeCGS
    extends CodeGenSupport {
        final int codedInputStreamVar = 1;
        int objVar;
        int tagVar;

        DecodeCGS(MethodVisitor method) {
            super(method);
        }

        void pushCodedInputStream() {
            this.mv.visitVarInsn(25, 1);
        }

        void call(String name, Type ret) {
            this.pushCodedInputStream();
            this.mv.visitMethodInsn(182, codedInputStream.getInternalName(), name, Type.getMethodDescriptor(ret, new Type[0]));
        }

        void ncallInt(String name, Type ret) {
            this.mv.visitMethodInsn(182, codedInputStream.getInternalName(), name, Type.getMethodDescriptor(ret, Type.INT_TYPE));
        }

        @Override
        public void pushEntity() {
            this.mv.visitVarInsn(25, this.objVar);
        }
    }

    private static class EncodeCGS
    extends SizeofCGS {
        private EncodeCGS(MethodVisitor method) {
            super(method);
        }

        void pushCodedOutputStream() {
            this.mv.visitVarInsn(25, 2);
        }

        void write(String name, Type arg) {
            this.mv.visitMethodInsn(182, codedOutputStream.getInternalName(), name, Type.getMethodDescriptor(Type.VOID_TYPE, Type.INT_TYPE, arg));
        }
    }

    private static class SizeofCGS
    extends CodeGenSupport {
        int sizeVar;

        SizeofCGS(MethodVisitor method) {
            super(method);
        }

        void doinc(String name, Type ... args) {
            this.mv.visitMethodInsn(184, codedOutputStream.getInternalName(), name, Type.getMethodDescriptor(Type.INT_TYPE, args));
            this.doinc();
        }

        void preinc() {
            this.mv.visitVarInsn(21, this.sizeVar);
        }

        void doinc() {
            this.mv.visitInsn(96);
            this.mv.visitVarInsn(54, this.sizeVar);
        }

        @Override
        public void pushEntity() {
            this.mv.visitVarInsn(25, 1);
        }
    }
}

