/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtorm.protobuf;

import com.google.gwtorm.protobuf.ByteBufferOutputStream;
import com.google.gwtorm.protobuf.CappedInputStream;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public abstract class ProtobufCodec<T> {
    public ByteString encodeToByteString(T obj) {
        return ByteString.copyFrom(this.encodeToByteBuffer(obj));
    }

    public ByteBuffer encodeToByteBuffer(T obj) {
        ByteBuffer data = ByteBuffer.allocate(this.sizeof(obj));
        this.encode(obj, data);
        data.flip();
        return data;
    }

    public byte[] encodeToByteArray(T obj) {
        byte[] data = new byte[this.sizeof(obj)];
        this.encode(obj, data);
        return data;
    }

    public void encode(T obj, byte[] data) {
        this.encode(obj, data, 0, data.length);
    }

    public void encode(T obj, byte[] data, int offset, int length) {
        CodedOutputStream out = CodedOutputStream.newInstance(data, offset, length);
        try {
            this.encode(obj, out);
            out.flush();
        }
        catch (IOException err) {
            throw new RuntimeException("Cannot encode message", err);
        }
    }

    public void encode(T obj, ByteBuffer buf) {
        if (buf.hasArray()) {
            CodedOutputStream out = CodedOutputStream.newInstance(buf.array(), buf.position(), buf.remaining());
            try {
                this.encode(obj, out);
                out.flush();
            }
            catch (IOException err) {
                throw new RuntimeException("Cannot encode message", err);
            }
            buf.position(buf.position() + (buf.remaining() - out.spaceLeft()));
        } else {
            CodedOutputStream out = CodedOutputStream.newInstance(ProtobufCodec.newStream(buf));
            try {
                this.encode(obj, out);
                out.flush();
            }
            catch (IOException err) {
                throw new RuntimeException("Cannot encode message", err);
            }
        }
    }

    public void encodeWithSize(T obj, OutputStream out) throws IOException {
        CodedOutputStream cos = CodedOutputStream.newInstance(out);
        cos.writeRawVarint32(this.sizeof(obj));
        this.encode(obj, cos);
        cos.flush();
    }

    private static ByteBufferOutputStream newStream(ByteBuffer buf) {
        return new ByteBufferOutputStream(buf);
    }

    public abstract void encode(T var1, CodedOutputStream var2) throws IOException;

    public abstract int sizeof(T var1);

    public abstract T newInstance();

    public T decode(ByteString buf) {
        T obj = this.newInstance();
        this.mergeFrom(buf, obj);
        return obj;
    }

    public T decode(byte[] data) {
        T obj = this.newInstance();
        this.mergeFrom(data, obj);
        return obj;
    }

    public T decode(byte[] data, int offset, int length) {
        T obj = this.newInstance();
        this.mergeFrom(data, offset, length, obj);
        return obj;
    }

    public T decode(ByteBuffer buf) {
        T obj = this.newInstance();
        this.mergeFrom(buf, obj);
        return obj;
    }

    public T decode(CodedInputStream in) throws IOException {
        T obj = this.newInstance();
        this.mergeFrom(in, obj);
        return obj;
    }

    public T decodeWithSize(InputStream in) throws IOException {
        T obj = this.newInstance();
        this.mergeFromWithSize(in, obj);
        return obj;
    }

    public void mergeFrom(ByteString buf, T obj) {
        try {
            this.mergeFrom(buf.newCodedInput(), obj);
        }
        catch (IOException err) {
            throw new RuntimeException("Cannot decode message", err);
        }
    }

    public void mergeFrom(byte[] data, T obj) {
        this.mergeFrom(data, 0, data.length, obj);
    }

    public void mergeFrom(byte[] data, int offset, int length, T obj) {
        try {
            this.mergeFrom(CodedInputStream.newInstance(data, offset, length), obj);
        }
        catch (IOException err) {
            throw new RuntimeException("Cannot decode message", err);
        }
    }

    public void mergeFrom(ByteBuffer buf, T obj) {
        if (buf.hasArray()) {
            CodedInputStream in = CodedInputStream.newInstance(buf.array(), buf.position(), buf.remaining());
            try {
                this.mergeFrom(in, obj);
            }
            catch (IOException err) {
                throw new RuntimeException("Cannot decode message", err);
            }
            buf.position(buf.position() + in.getTotalBytesRead());
        } else {
            this.mergeFrom(ByteString.copyFrom(buf), obj);
        }
    }

    public void mergeFromWithSize(InputStream in, T obj) throws IOException {
        int sz = ProtobufCodec.readRawVarint32(in);
        this.mergeFrom(CodedInputStream.newInstance(new CappedInputStream(in, sz)), obj);
    }

    public abstract void mergeFrom(CodedInputStream var1, T var2) throws IOException;

    private static int readRawVarint32(InputStream in) throws IOException {
        int offset;
        int b = in.read();
        if (b == -1) {
            throw new InvalidProtocolBufferException("Truncated input");
        }
        if ((b & 0x80) == 0) {
            return b;
        }
        int result = b & 0x7F;
        for (offset = 7; offset < 32; offset += 7) {
            b = in.read();
            if (b == -1) {
                throw new InvalidProtocolBufferException("Truncated input");
            }
            result |= (b & 0x7F) << offset;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        while (offset < 64) {
            b = in.read();
            if (b == -1) {
                throw new InvalidProtocolBufferException("Truncated input");
            }
            if ((b & 0x80) == 0) {
                return result;
            }
            offset += 7;
        }
        throw new InvalidProtocolBufferException("Malformed varint");
    }
}

