/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtorm.schema;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gwtorm.schema.ColumnModel;
import com.google.gwtorm.schema.KeyModel;
import com.google.gwtorm.schema.QueryModel;
import com.google.gwtorm.schema.Util;
import com.google.gwtorm.schema.sql.SqlDialect;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.PrimaryKey;
import com.google.gwtorm.server.Relation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;

public abstract class RelationModel {
    protected String methodName;
    protected String relationName;
    protected Relation relation;
    protected final Map<String, ColumnModel> fieldsByFieldName = Maps.newLinkedHashMap();
    protected final Map<String, ColumnModel> columnsByColumnName = Maps.newLinkedHashMap();
    protected final SortedMap<Integer, ColumnModel> columnsById = Maps.newTreeMap();
    protected KeyModel primaryKey;
    protected Collection<QueryModel> queries = Lists.newArrayList();

    protected RelationModel() {
    }

    protected void initName(String method, Relation rel) throws OrmException {
        if (rel == null) {
            throw new OrmException("Method " + method + " is missing " + Relation.class.getName() + " annotation");
        }
        this.relation = rel;
        this.methodName = method;
        this.relationName = Util.any(this.relation.name(), Util.makeSqlFriendly(this.methodName));
    }

    protected void initColumns(Collection<? extends ColumnModel> allFields) throws OrmException {
        for (ColumnModel columnModel : allFields) {
            if (this.fieldsByFieldName.put(columnModel.getFieldName(), columnModel) != null) {
                throw new OrmException("Duplicate fields " + columnModel.getFieldName());
            }
            if (this.columnsById.put(columnModel.getColumnID(), columnModel) != null) {
                throw new OrmException("Duplicate @Column id " + columnModel.getColumnID() + " in " + columnModel.getPathToFieldName());
            }
            if (columnModel.isNested()) {
                for (ColumnModel newCol : columnModel.getAllLeafColumns()) {
                    this.registerColumn(newCol);
                }
                continue;
            }
            this.registerColumn(columnModel);
        }
    }

    private void registerColumn(ColumnModel nc) throws OrmException {
        ColumnModel name = this.columnsByColumnName.put(nc.getColumnName(), nc);
        if (name != null) {
            throw new OrmException("Duplicate columns " + nc.getColumnName() + " in " + this.getMethodName() + ":\n" + "prior " + name.getPathToFieldName() + "\n next  " + nc.getPathToFieldName());
        }
    }

    protected void initPrimaryKey(String name, PrimaryKey annotation) throws OrmException {
        if (this.primaryKey != null) {
            throw new OrmException("Duplicate primary key definitions");
        }
        ColumnModel field = this.getField(annotation.value());
        if (field == null) {
            throw new OrmException("Field " + annotation.value() + " not in " + this.getEntityTypeClassName());
        }
        this.primaryKey = new KeyModel(name, field);
        for (ColumnModel c : this.primaryKey.getAllLeafColumns()) {
            c.inPrimaryKey = true;
        }
    }

    protected void addQuery(QueryModel q) throws OrmException {
        for (QueryModel e : this.queries) {
            if (!e.getName().equals(q.getName())) continue;
            throw new OrmException("Duplicate query " + q.getName() + " in " + this.getAccessInterfaceName());
        }
        this.queries.add(q);
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getRelationName() {
        return this.relationName;
    }

    public int getRelationID() {
        return this.relation.id();
    }

    public Collection<ColumnModel> getDependentFields() {
        ArrayList<ColumnModel> r = new ArrayList<ColumnModel>();
        for (ColumnModel c : this.fieldsByFieldName.values()) {
            if (c.rowVersion || this.primaryKey != null && this.primaryKey.getField() == c) continue;
            r.add(c);
        }
        return r;
    }

    public Collection<ColumnModel> getDependentColumns() {
        ArrayList<ColumnModel> r = new ArrayList<ColumnModel>();
        for (ColumnModel c : this.columnsByColumnName.values()) {
            if (c.inPrimaryKey || c.rowVersion) continue;
            r.add(c);
        }
        return r;
    }

    public Collection<ColumnModel> getRowVersionFields() {
        ArrayList<ColumnModel> r = new ArrayList<ColumnModel>();
        for (ColumnModel c : this.fieldsByFieldName.values()) {
            if (!c.rowVersion) continue;
            r.add(c);
        }
        return r;
    }

    public Collection<ColumnModel> getRowVersionColumns() {
        ArrayList<ColumnModel> r = new ArrayList<ColumnModel>();
        for (ColumnModel c : this.columnsByColumnName.values()) {
            if (!c.rowVersion) continue;
            r.add(c);
        }
        return r;
    }

    public KeyModel getPrimaryKey() {
        return this.primaryKey;
    }

    public Collection<ColumnModel> getPrimaryKeyColumns() {
        if (this.getPrimaryKey() != null) {
            return this.getPrimaryKey().getAllLeafColumns();
        }
        return Collections.emptyList();
    }

    public Collection<QueryModel> getQueries() {
        return this.queries;
    }

    public Collection<ColumnModel> getColumns() {
        ArrayList<ColumnModel> r = new ArrayList<ColumnModel>();
        r.addAll(this.getDependentColumns());
        r.addAll(this.getRowVersionColumns());
        r.addAll(this.getPrimaryKeyColumns());
        return r;
    }

    public Collection<ColumnModel> getFields() {
        return this.fieldsByFieldName.values();
    }

    public ColumnModel getField(String name) {
        return this.fieldsByFieldName.get(name);
    }

    public ColumnModel getColumn(String name) {
        return this.columnsByColumnName.get(name);
    }

    public String getCreateTableSql(SqlDialect dialect) {
        ColumnModel col;
        StringBuilder r = new StringBuilder();
        r.append("CREATE TABLE ");
        r.append(this.relationName);
        r.append(" (\n");
        Iterator<ColumnModel> i = this.getColumns().iterator();
        while (i.hasNext()) {
            col = i.next();
            r.append(col.getColumnName());
            r.append(" ");
            r.append(dialect.getSqlTypeInfo(col).getSqlType(col, dialect));
            String check = dialect.getSqlTypeInfo(col).getCheckConstraint(col, dialect);
            if (check != null) {
                r.append(' ');
                r.append(check);
            }
            if (i.hasNext()) {
                r.append(",");
            }
            r.append("\n");
        }
        if (!this.getPrimaryKeyColumns().isEmpty()) {
            r.append(",PRIMARY KEY(");
            i = this.getPrimaryKeyColumns().iterator();
            while (i.hasNext()) {
                col = i.next();
                r.append(col.getColumnName());
                if (!i.hasNext()) continue;
                r.append(",");
            }
            r.append(")\n");
        }
        r.append(")");
        dialect.appendCreateTableStorage(r, this);
        return r.toString();
    }

    public String getSelectSql(SqlDialect dialect, String tableAlias) {
        StringBuilder r = new StringBuilder();
        r.append("SELECT ");
        Iterator<ColumnModel> i = this.getColumns().iterator();
        while (i.hasNext()) {
            ColumnModel col = i.next();
            r.append(tableAlias);
            r.append('.');
            r.append(col.getColumnName());
            if (!i.hasNext()) continue;
            r.append(",");
        }
        r.append(" FROM ");
        r.append(this.relationName);
        r.append(' ');
        r.append(tableAlias);
        return r.toString();
    }

    public String getInsertOneSql(SqlDialect dialect) {
        StringBuilder r = new StringBuilder();
        r.append("INSERT INTO ");
        r.append(this.relationName);
        r.append("(");
        Iterator<ColumnModel> i = this.getColumns().iterator();
        while (i.hasNext()) {
            ColumnModel col = i.next();
            r.append(col.getColumnName());
            if (!i.hasNext()) continue;
            r.append(",");
        }
        r.append(")VALUES(");
        int nth = 1;
        Iterator<ColumnModel> i2 = this.getColumns().iterator();
        while (i2.hasNext()) {
            i2.next();
            r.append(dialect.getParameterPlaceHolder(nth++));
            if (!i2.hasNext()) continue;
            r.append(",");
        }
        r.append(")");
        return r.toString();
    }

    public String getUpdateOneSql(SqlDialect dialect) {
        ColumnModel col;
        StringBuilder r = new StringBuilder();
        r.append("UPDATE ");
        r.append(this.relationName);
        r.append(" SET ");
        int nth = 1;
        ArrayList<ColumnModel> cols = new ArrayList<ColumnModel>();
        cols.addAll(this.getDependentColumns());
        cols.addAll(this.getRowVersionColumns());
        Iterator i = cols.iterator();
        while (i.hasNext()) {
            col = (ColumnModel)i.next();
            r.append(col.getColumnName());
            r.append("=");
            r.append(dialect.getParameterPlaceHolder(nth++));
            if (!i.hasNext()) continue;
            r.append(",");
        }
        r.append(" WHERE ");
        cols = new ArrayList();
        cols.addAll(this.getPrimaryKeyColumns());
        cols.addAll(this.getRowVersionColumns());
        i = cols.iterator();
        while (i.hasNext()) {
            col = (ColumnModel)i.next();
            r.append(col.getColumnName());
            r.append("=");
            r.append(dialect.getParameterPlaceHolder(nth++));
            if (!i.hasNext()) continue;
            r.append(" AND ");
        }
        return r.toString();
    }

    public String getDeleteOneSql(SqlDialect dialect) {
        StringBuilder r = new StringBuilder();
        r.append("DELETE FROM ");
        r.append(this.relationName);
        int nth = 1;
        r.append(" WHERE ");
        ArrayList<ColumnModel> cols = new ArrayList<ColumnModel>();
        cols.addAll(this.getPrimaryKeyColumns());
        cols.addAll(this.getRowVersionColumns());
        Iterator i = cols.iterator();
        while (i.hasNext()) {
            ColumnModel col = (ColumnModel)i.next();
            r.append(col.getColumnName());
            r.append("=");
            r.append(dialect.getParameterPlaceHolder(nth++));
            if (!i.hasNext()) continue;
            r.append(" AND ");
        }
        return r.toString();
    }

    public abstract String getAccessInterfaceName();

    public abstract String getEntityTypeClassName();

    public String toString() {
        StringBuilder r = new StringBuilder();
        r.append("Relation[\n");
        r.append("  method: " + this.getMethodName() + "\n");
        r.append("  table:  " + this.getRelationName() + "\n");
        r.append("  id:     " + this.getRelationID() + "\n");
        r.append("  access: " + this.getAccessInterfaceName() + "\n");
        r.append("  entity: " + this.getEntityTypeClassName() + "\n");
        r.append("]");
        return r.toString();
    }
}

