/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtorm.schema;

import com.google.gwtorm.schema.RelationModel;
import com.google.gwtorm.schema.SequenceModel;
import com.google.gwtorm.schema.sql.SqlDialect;
import com.google.gwtorm.server.OrmException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public abstract class SchemaModel {
    protected final Set<String> allNames = new HashSet<String>();
    protected final Map<String, RelationModel> relations = new TreeMap<String, RelationModel>();
    protected final Map<String, SequenceModel> sequences = new TreeMap<String, SequenceModel>();

    protected SchemaModel() {
    }

    protected void add(RelationModel r) throws OrmException {
        String n = r.getRelationName();
        this.checkNotUsed(n);
        if (this.relations.put(n, r) != null) {
            throw new OrmException("Duplicate relations " + n);
        }
        this.allNames.add(n);
    }

    protected void add(SequenceModel s) throws OrmException {
        String n = s.getSequenceName();
        this.checkNotUsed(n);
        if (this.sequences.put(n, s) != null) {
            throw new OrmException("Duplicate sequences " + n);
        }
        this.allNames.add(n);
    }

    private void checkNotUsed(String n) throws OrmException {
        if (this.allNames.contains(n)) {
            throw new OrmException("Name " + n + " already used");
        }
    }

    public Collection<RelationModel> getRelations() {
        return this.relations.values();
    }

    public Collection<SequenceModel> getSequences() {
        return this.sequences.values();
    }

    public String getCreateDatabaseSql(SqlDialect dialect) {
        StringBuffer r = new StringBuffer();
        for (SequenceModel seq : this.getSequences()) {
            r.append(seq.getCreateSequenceSql(dialect));
            r.append(";\n");
        }
        if (!this.getSequences().isEmpty()) {
            r.append("\n");
        }
        for (RelationModel rel : this.getRelations()) {
            r.append(rel.getCreateTableSql(dialect));
            r.append(";\n\n");
        }
        return r.toString();
    }

    public abstract String getSchemaClassName();

    public String toString() {
        return "Schema[" + this.getSchemaClassName() + "]";
    }
}

