/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtorm.schema.sql;

import com.google.gwtorm.client.Column;
import com.google.gwtorm.schema.ColumnModel;
import com.google.gwtorm.schema.sql.SqlDialect;
import com.google.gwtorm.schema.sql.SqlTypeInfo;
import com.google.gwtorm.server.CodeGenSupport;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.objectweb.asm.Type;

public class SqlStringTypeInfo
extends SqlTypeInfo {
    @Override
    protected String getJavaSqlTypeAlias() {
        return "String";
    }

    @Override
    protected int getSqlTypeConstant() {
        return 12;
    }

    @Override
    public String getSqlType(ColumnModel col, SqlDialect dialect) {
        Column column = col.getColumnAnnotation();
        StringBuilder r = new StringBuilder();
        if (column.length() <= 0) {
            r.append("VARCHAR(255)");
        } else if (column.length() <= 255) {
            r.append("VARCHAR(" + column.length() + ")");
        } else {
            r.append(dialect.getSqlTypeName(-1));
        }
        if (col.isNotNull()) {
            r.append(" DEFAULT ''");
            r.append(" NOT NULL");
        }
        return r.toString();
    }

    @Override
    public void generatePreparedStatementSet(CodeGenSupport cgs) {
        if (cgs.getFieldReference().getColumnAnnotation().length() <= 255) {
            super.generatePreparedStatementSet(cgs);
        } else {
            cgs.pushSqlHandle();
            cgs.pushColumnIndex();
            cgs.pushFieldValue();
            cgs.mv.visitMethodInsn(184, Type.getInternalName(SqlStringTypeInfo.class), "toPreparedStatement", Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(PreparedStatement.class), Type.INT_TYPE, Type.getType(String.class)));
        }
    }

    @Override
    public void generateResultSetGet(CodeGenSupport cgs) {
        if (cgs.getFieldReference().getColumnAnnotation().length() <= 255) {
            super.generateResultSetGet(cgs);
        } else {
            cgs.fieldSetBegin();
            cgs.pushSqlHandle();
            cgs.pushColumnIndex();
            cgs.mv.visitMethodInsn(184, Type.getInternalName(SqlStringTypeInfo.class), "fromResultSet", Type.getMethodDescriptor(Type.getType(String.class), Type.getType(ResultSet.class), Type.INT_TYPE));
            cgs.fieldSetEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String fromResultSet(ResultSet rs, int col) throws SQLException {
        String string;
        Reader r = rs.getCharacterStream(col);
        if (r == null) {
            return null;
        }
        try {
            int n;
            StringWriter w = new StringWriter();
            char[] buf = new char[1024];
            while ((n = r.read(buf)) > 0) {
                w.write(buf, 0, n);
            }
            string = w.toString();
        }
        catch (Throwable throwable) {
            try {
                r.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new SQLException("Unable to read CharacterStream in column " + col);
            }
        }
        r.close();
        return string;
    }

    public static void toPreparedStatement(PreparedStatement ps, int col, String txt) throws SQLException {
        if (txt != null) {
            ps.setCharacterStream(col, (Reader)new StringReader(txt), txt.length());
        } else {
            ps.setNull(col, -1);
        }
    }
}

