/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.servlet;

import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.servlet.DefaultFilterPipeline;
import com.google.inject.servlet.FilterPipeline;
import com.google.inject.servlet.GuiceFilter;
import com.google.inject.servlet.ManagedFilterPipeline;
import com.google.inject.servlet.ManagedServletPipeline;
import com.google.inject.servlet.RequestParameters;
import com.google.inject.servlet.RequestScoped;
import com.google.inject.servlet.ScopingOnly;
import com.google.inject.servlet.ServletScopes;
import com.google.inject.servlet.SessionScoped;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class InternalServletModule
extends AbstractModule {
    InternalServletModule() {
    }

    @Override
    protected void configure() {
        this.bindScope(RequestScoped.class, ServletScopes.REQUEST);
        this.bindScope(SessionScoped.class, ServletScopes.SESSION);
        this.bind(ServletRequest.class).to(HttpServletRequest.class);
        this.bind(ServletResponse.class).to(HttpServletResponse.class);
        this.requestStaticInjection(GuiceFilter.class);
        this.bind(ManagedFilterPipeline.class);
        this.bind(ManagedServletPipeline.class);
        this.bind(FilterPipeline.class).to(ManagedFilterPipeline.class).asEagerSingleton();
        this.bind(ServletContext.class).toProvider(BackwardsCompatibleServletContextProvider.class);
        this.bind(BackwardsCompatibleServletContextProvider.class);
    }

    @Provides
    @Singleton
    @ScopingOnly
    GuiceFilter provideScopingOnlyGuiceFilter() {
        return new GuiceFilter(new DefaultFilterPipeline());
    }

    @Provides
    @RequestScoped
    HttpServletRequest provideHttpServletRequest() {
        return GuiceFilter.getRequest();
    }

    @Provides
    @RequestScoped
    HttpServletResponse provideHttpServletResponse() {
        return GuiceFilter.getResponse();
    }

    @Provides
    HttpSession provideHttpSession() {
        return GuiceFilter.getRequest().getSession();
    }

    @Provides
    @RequestScoped
    @RequestParameters
    Map<String, String[]> provideRequestParameters(ServletRequest req) {
        return req.getParameterMap();
    }

    public boolean equals(Object o) {
        return o instanceof InternalServletModule;
    }

    public int hashCode() {
        return InternalServletModule.class.hashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Singleton
    static class BackwardsCompatibleServletContextProvider
    implements Provider<ServletContext> {
        private ServletContext injectedServletContext;

        @Inject
        BackwardsCompatibleServletContextProvider() {
        }

        void set(ServletContext injectedServletContext) {
            this.injectedServletContext = injectedServletContext;
        }

        @Override
        public ServletContext get() {
            if (null != this.injectedServletContext) {
                return this.injectedServletContext;
            }
            Logger.getLogger(InternalServletModule.class.getName()).warning("You are attempting to use a deprecated API (specifically, attempting to @Inject ServletContext inside an eagerly created singleton. While we allow this for backwards compatibility, be warned that this MAY have unexpected behavior if you have more than one injector (with ServletModule) running in the same JVM. Please consult the Guice documentation at http://code.google.com/p/google-guice/wiki/Servlets for more information.");
            return GuiceFilter.getServletContext();
        }
    }
}

