/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.prolog_cafe.builtin;

import com.googlecode.prolog_cafe.lang.IllegalDomainException;
import com.googlecode.prolog_cafe.lang.IllegalTypeException;
import com.googlecode.prolog_cafe.lang.IntegerTerm;
import com.googlecode.prolog_cafe.lang.ListTerm;
import com.googlecode.prolog_cafe.lang.Operation;
import com.googlecode.prolog_cafe.lang.PInstantiationException;
import com.googlecode.prolog_cafe.lang.Predicate;
import com.googlecode.prolog_cafe.lang.Prolog;
import com.googlecode.prolog_cafe.lang.StructureTerm;
import com.googlecode.prolog_cafe.lang.SymbolTerm;
import com.googlecode.prolog_cafe.lang.Term;
import com.googlecode.prolog_cafe.lang.VariableTerm;

public class PRED_functor_3
extends Predicate.P3 {
    private static final SymbolTerm SYM_DOT = SymbolTerm.intern(".");

    public PRED_functor_3(Term term, Term term2, Term term3, Operation operation) {
        this.arg1 = term;
        this.arg2 = term2;
        this.arg3 = term3;
        this.cont = operation;
    }

    @Override
    public Operation exec(Prolog prolog) {
        IntegerTerm integerTerm;
        Term term;
        prolog.setB0();
        Term term2 = this.arg1;
        Term term3 = this.arg2;
        Term term4 = this.arg3;
        term2 = term2.dereference();
        if (term2.isVariable()) {
            if ((term3 = term3.dereference()).isVariable()) {
                throw new PInstantiationException(this, 2);
            }
            if (!(term3.isSymbol() || term3.isNumber() || term3.isJavaObject() || term3.isClosure())) {
                throw new IllegalTypeException(this, 2, "atomic", term3);
            }
            if ((term4 = term4.dereference()).isVariable()) {
                throw new PInstantiationException(this, 3);
            }
            if (!term4.isInteger()) {
                throw new IllegalTypeException(this, 3, "integer", term4);
            }
            int n = ((IntegerTerm)term4).intValue();
            if (n < 0) {
                throw new IllegalDomainException(this, 3, "not_less_than_zero", term4);
            }
            if (n == 0) {
                if (!term2.unify(term3, prolog.trail)) {
                    return prolog.fail();
                }
                return this.cont;
            }
            if (!term3.isSymbol()) {
                throw new IllegalTypeException(this, 2, "atom", term3);
            }
            if (n == 2 && term3.equals(SYM_DOT)) {
                ListTerm listTerm = new ListTerm(new VariableTerm(prolog), new VariableTerm(prolog));
                if (!term2.unify(listTerm, prolog.trail)) {
                    return prolog.fail();
                }
                return this.cont;
            }
            Term[] termArray = new Term[n];
            for (int i = 0; i < n; ++i) {
                termArray[i] = new VariableTerm(prolog);
            }
            SymbolTerm symbolTerm = SymbolTerm.create(((SymbolTerm)term3).name(), n);
            if (!term2.unify(new StructureTerm(symbolTerm, termArray), prolog.trail)) {
                return prolog.fail();
            }
            return this.cont;
        }
        if (term2.isSymbol() || term2.isNumber() || term2.isJavaObject() || term2.isClosure()) {
            term = term2;
            integerTerm = new IntegerTerm(0);
        } else if (term2.isList()) {
            term = SYM_DOT;
            integerTerm = new IntegerTerm(2);
        } else if (term2.isStructure()) {
            term = SymbolTerm.create(((StructureTerm)term2).name());
            integerTerm = new IntegerTerm(((StructureTerm)term2).arity());
        } else {
            return prolog.fail();
        }
        if (!term3.unify(term, prolog.trail)) {
            return prolog.fail();
        }
        if (!term4.unify(integerTerm, prolog.trail)) {
            return prolog.fail();
        }
        return this.cont;
    }
}

