/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.prolog_cafe.builtin;

import com.googlecode.prolog_cafe.lang.ExistenceException;
import com.googlecode.prolog_cafe.lang.IllegalDomainException;
import com.googlecode.prolog_cafe.lang.IllegalTypeException;
import com.googlecode.prolog_cafe.lang.IntegerTerm;
import com.googlecode.prolog_cafe.lang.JavaObjectTerm;
import com.googlecode.prolog_cafe.lang.Operation;
import com.googlecode.prolog_cafe.lang.PInstantiationException;
import com.googlecode.prolog_cafe.lang.PermissionException;
import com.googlecode.prolog_cafe.lang.Predicate;
import com.googlecode.prolog_cafe.lang.Prolog;
import com.googlecode.prolog_cafe.lang.RepresentationException;
import com.googlecode.prolog_cafe.lang.Term;
import com.googlecode.prolog_cafe.lang.TermException;
import java.io.IOException;
import java.io.PushbackReader;

public class PRED_peek_byte_2
extends Predicate.P2 {
    private static final IntegerTerm INT_EOF = new IntegerTerm(-1);

    public PRED_peek_byte_2(Term term, Term term2, Operation operation) {
        this.arg1 = term;
        this.arg2 = term2;
        this.cont = operation;
    }

    @Override
    public Operation exec(Prolog prolog) {
        int n;
        prolog.setB0();
        Term term = this.arg1;
        Term term2 = this.arg2;
        Object object = null;
        term2 = term2.dereference();
        if (!term2.isVariable()) {
            if (!term2.isInteger()) {
                throw new IllegalTypeException(this, 2, "in_byte", term2);
            }
            n = ((IntegerTerm)term2).intValue();
            if (n != -1 && (n < 0 || n > 255)) {
                throw new RepresentationException(this, 2, "in_byte");
            }
        }
        if ((term = term.dereference()).isVariable()) {
            throw new PInstantiationException(this, 1);
        }
        if (term.isSymbol()) {
            if (!prolog.getStreamManager().containsKey(term)) {
                throw new ExistenceException(this, 1, "stream", term, "");
            }
            object = ((JavaObjectTerm)prolog.getStreamManager().get(term)).object();
        } else if (term.isJavaObject()) {
            object = ((JavaObjectTerm)term).object();
        } else {
            throw new IllegalDomainException(this, 1, "stream_or_alias", term);
        }
        if (!(object instanceof PushbackReader)) {
            throw new PermissionException(this, "input", "stream", term, "");
        }
        try {
            n = ((PushbackReader)object).read();
            if (n < 0) {
                if (!term2.unify(INT_EOF, prolog.trail)) {
                    return prolog.fail();
                }
                return this.cont;
            }
            if (n > 255) {
                throw new RepresentationException(this, 0, "byte");
            }
            ((PushbackReader)object).unread(n);
            if (!term2.unify(new IntegerTerm(n), prolog.trail)) {
                return prolog.fail();
            }
            return this.cont;
        }
        catch (IOException iOException) {
            throw new TermException(new JavaObjectTerm(iOException));
        }
    }
}

