/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.prolog_cafe.lang;

import com.googlecode.prolog_cafe.lang.InternalException;
import com.googlecode.prolog_cafe.lang.StructureTerm;
import com.googlecode.prolog_cafe.lang.Term;
import com.googlecode.prolog_cafe.lang.Token;
import com.googlecode.prolog_cafe.lang.Trail;
import com.googlecode.prolog_cafe.lang.VariableTerm;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentHashMap;

public abstract class SymbolTerm
extends Term {
    private static final ConcurrentHashMap<Key, InternRef> SYMBOL_TABLE = new ConcurrentHashMap();
    private static final ReferenceQueue<Interned> DEAD = new ReferenceQueue();
    private static final SymbolTerm colon2 = SymbolTerm.intern(":", 2);
    protected final String name;
    protected final int arity;

    public static SymbolTerm create(char c) {
        if ('\u0000' <= c && c <= '\u007f') {
            return SymbolTerm.intern(Character.toString(c), 0);
        }
        return SymbolTerm.create(Character.toString(c));
    }

    public static SymbolTerm create(String string) {
        return new Dynamic(string, 0);
    }

    public static SymbolTerm create(String string, int n) {
        if (n != 0) {
            return SymbolTerm.softReuse(string, n);
        }
        return new Dynamic(string, 0);
    }

    public static StructureTerm create(String string, String string2, int n) {
        return new StructureTerm(colon2, SymbolTerm.softReuse(string, 0), SymbolTerm.softReuse(string2, n));
    }

    public static SymbolTerm intern(String string) {
        return SymbolTerm.intern(string, 0);
    }

    public static SymbolTerm intern(String string, int n) {
        SymbolTerm symbolTerm;
        Interned interned;
        Key key = new Key(string = string.intern(), n);
        Reference reference = SYMBOL_TABLE.get(key);
        if (reference != null) {
            interned = (Interned)reference.get();
            if (interned != null) {
                return interned;
            }
            SYMBOL_TABLE.remove(key, reference);
            reference.enqueue();
        }
        SymbolTerm.gc();
        interned = new Interned(string, n);
        InternRef internRef = new InternRef(key, interned);
        InternRef internRef2 = SYMBOL_TABLE.putIfAbsent(key, internRef);
        if (internRef2 != null && (symbolTerm = (SymbolTerm)internRef2.get()) != null) {
            return symbolTerm;
        }
        return interned;
    }

    static void gc() {
        Reference<Interned> reference;
        while ((reference = DEAD.poll()) != null) {
            SYMBOL_TABLE.remove(((InternRef)reference).key, reference);
        }
    }

    private static SymbolTerm softReuse(String string, int n) {
        Key key = new Key(string, n);
        Reference reference = SYMBOL_TABLE.get(key);
        if (reference != null) {
            Interned interned = (Interned)reference.get();
            if (interned != null) {
                return interned;
            }
            SYMBOL_TABLE.remove(key, reference);
            reference.enqueue();
        }
        return new Dynamic(string, n);
    }

    protected SymbolTerm(String string, int n) {
        this.name = string;
        this.arity = n;
    }

    @Override
    public int arity() {
        return this.arity;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public boolean unify(Term term, Trail trail) {
        if ((term = term.dereference()).isVariable()) {
            ((VariableTerm)term).bind(this, trail);
            return true;
        }
        return SymbolTerm.eq(this, term);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof Term && SymbolTerm.eq(this, (Term)object);
    }

    private static boolean eq(SymbolTerm symbolTerm, Term term) {
        if (symbolTerm == term) {
            return true;
        }
        if (term instanceof SymbolTerm && (symbolTerm instanceof Dynamic || term instanceof Dynamic)) {
            SymbolTerm symbolTerm2 = (SymbolTerm)term;
            return symbolTerm.arity == symbolTerm2.arity && symbolTerm.name.equals(symbolTerm2.name);
        }
        return false;
    }

    @Override
    public boolean convertible(Class clazz) {
        return SymbolTerm.convertible(String.class, clazz);
    }

    @Override
    public Object toJava() {
        return this.name;
    }

    @Override
    public String toQuotedString() {
        return Token.toQuotedString(this.name);
    }

    public String toString() {
        return this.name;
    }

    @Override
    public int compareTo(Term term) {
        if (term.isVariable() || term.isNumber()) {
            return 1;
        }
        if (!term.isSymbol()) {
            return -1;
        }
        if (this == term) {
            return 0;
        }
        int n = this.name.compareTo(((SymbolTerm)term).name());
        if (n != 0) {
            return n;
        }
        int n2 = this.arity - ((SymbolTerm)term).arity();
        if (n2 != 0) {
            return n2;
        }
        throw new InternalException("SymbolTerm is not unique");
    }

    private static final class Interned
    extends SymbolTerm {
        Interned(String string, int n) {
            super(string, n);
        }
    }

    private static final class Dynamic
    extends SymbolTerm {
        Dynamic(String string, int n) {
            super(string, n);
        }
    }

    private static final class InternRef
    extends WeakReference<Interned> {
        final Key key;

        InternRef(Key key, Interned interned) {
            super(interned, DEAD);
            this.key = key;
        }
    }

    private static final class Key {
        final String name;
        final int arity;

        Key(String string, int n) {
            this.name = string;
            this.arity = n;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object object) {
            Key key = (Key)object;
            return this.arity == key.arity && this.name.equals(key.name);
        }
    }
}

