/*
 * Decompiled with CFR 0.152.
 */
package eu.medsea.util;

import java.io.ByteArrayOutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncodingGuesser {
    private static final long serialVersionUID = -247389882161262839L;
    private static Logger log;
    private static String defaultJVMEncoding;
    private static Collection supportedEncodings;
    private static Map boms;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("eu.medsea.util.EncodingGuesser");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LoggerFactory.getLogger(clazz);
        defaultJVMEncoding = Charset.forName(new OutputStreamWriter(new ByteArrayOutputStream()).getEncoding()).name();
        supportedEncodings = new TreeSet();
        boms = new HashMap();
        byte[] byArray = new byte[4];
        byArray[2] = -2;
        byArray[3] = -1;
        boms.put("UTF-32BE", byArray);
        byte[] byArray2 = new byte[4];
        byArray2[0] = -1;
        byArray2[1] = -2;
        boms.put("UTF-32LE", byArray2);
        boms.put("UTF-16BE", new byte[]{-2, -1});
        boms.put("UTF-16LE", new byte[]{-1, -2});
        boms.put("UTF-8", new byte[]{-17, -69, -65});
        boms.put("UTF-7", new byte[]{43, 47, 118});
        boms.put("UTF-1", new byte[]{-9, 100, 76});
        boms.put("UTF-EBCDIC", new byte[]{-35, 115, 102, 115});
        boms.put("SCSU", new byte[]{14, -2, -1});
        boms.put("BOCU-1", new byte[]{-5, -18, 40});
    }

    public static boolean isKnownEncoding(String encoding) {
        return supportedEncodings.contains(encoding);
    }

    public static Collection getPossibleEncodings(byte[] data) {
        TreeSet<String> possibleEncodings = new TreeSet<String>();
        if (data == null || data.length == 0) {
            return possibleEncodings;
        }
        String encoding = null;
        Iterator it = supportedEncodings.iterator();
        while (it.hasNext()) {
            try {
                encoding = (String)it.next();
                int lengthBOM = EncodingGuesser.getLengthBOM(encoding, data);
                String test = new String(EncodingGuesser.getByteArraySubArray(data, lengthBOM, data.length - lengthBOM), encoding);
                if (test.length() > 1) {
                    test = test.substring(0, test.length() - 2);
                }
                byte[] compare = null;
                try {
                    compare = test.getBytes(encoding);
                }
                catch (UnsupportedOperationException ignore) {
                    continue;
                }
                if (!EncodingGuesser.compareByteArrays(data, lengthBOM, compare, 0, compare.length)) continue;
                if (lengthBOM != 0) {
                    possibleEncodings.clear();
                    possibleEncodings.add(encoding);
                    return possibleEncodings;
                }
                possibleEncodings.add(encoding);
            }
            catch (UnsupportedEncodingException uee) {
                log.error("The encoding [" + encoding + "] is not supported by your JVM.");
            }
            catch (Exception e) {
                log.error(e.getLocalizedMessage(), e);
            }
        }
        return possibleEncodings;
    }

    public static boolean removeEncoding(String encoding) {
        return supportedEncodings.remove(encoding);
    }

    public static boolean removeEncodings(String[] encodings) {
        boolean removedAtLeast_1 = false;
        int i = 0;
        while (i < encodings.length) {
            if (EncodingGuesser.removeEncoding(encodings[i])) {
                removedAtLeast_1 = true;
            }
            ++i;
        }
        return removedAtLeast_1;
    }

    public static Collection getValidEncodings(String[] encodings) {
        ArrayList<String> c = new ArrayList<String>();
        int i = 0;
        while (i < encodings.length) {
            if (supportedEncodings.contains(encodings[i])) {
                c.add(encodings[i]);
            }
            ++i;
        }
        return c;
    }

    public static String getDefaultEncoding() {
        return defaultJVMEncoding;
    }

    public static Collection getSupportedEncodings() {
        return supportedEncodings;
    }

    public static Collection setSupportedEncodings(Collection encodings) {
        TreeSet current = new TreeSet();
        Iterator it = supportedEncodings.iterator();
        while (it.hasNext()) {
            current.add(it.next());
        }
        if (encodings != null) {
            supportedEncodings.clear();
            it = encodings.iterator();
            while (it.hasNext()) {
                supportedEncodings.add(it.next());
            }
        }
        return current;
    }

    public static int getLengthBOM(String encoding, byte[] data) {
        if (!boms.containsKey(encoding)) {
            return 0;
        }
        byte[] bom = (byte[])boms.get(encoding);
        if (EncodingGuesser.compareByteArrays(bom, 0, data, 0, bom.length)) {
            return bom.length;
        }
        return 0;
    }

    public static byte[] getByteArraySubArray(byte[] a, int offset, int length) {
        if (offset + length > a.length) {
            return a;
        }
        byte[] data = new byte[length];
        int i = 0;
        while (i < length) {
            data[i] = a[offset + i];
            ++i;
        }
        return data;
    }

    public static boolean compareByteArrays(byte[] a, int aOffset, byte[] b, int bOffset, int length) {
        if (a.length < aOffset + length || b.length < bOffset + length) {
            return false;
        }
        int i = 0;
        while (i < length) {
            if (a[aOffset + i] != b[bOffset + i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static Collection getCanonicalEncodingNamesSupportedByJVM() {
        TreeSet<String> encodings = new TreeSet<String>();
        SortedMap<String, Charset> charSets = Charset.availableCharsets();
        Set<String> charSetNames = charSets.keySet();
        Iterator it = charSetNames.iterator();
        while (it.hasNext()) {
            encodings.add((String)it.next());
        }
        if (log.isDebugEnabled()) {
            log.debug("The following [" + encodings.size() + "] encodings will be used: " + encodings);
        }
        return encodings;
    }
}

