/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.auth.deprecated;

import java.io.IOException;
import java.security.KeyPair;
import java.security.interfaces.RSAPublicKey;
import org.apache.sshd.client.auth.deprecated.AbstractUserAuth;
import org.apache.sshd.client.auth.deprecated.UserAuth;
import org.apache.sshd.client.session.ClientSessionImpl;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.Signature;
import org.apache.sshd.common.util.Buffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserAuthPublicKey
extends AbstractUserAuth {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final KeyPair key;

    public UserAuthPublicKey(ClientSessionImpl session, String service, KeyPair key) {
        super(session, service);
        this.key = key;
    }

    public UserAuth.Result next(Buffer buffer) throws IOException {
        if (buffer == null) {
            try {
                this.log.debug("Send SSH_MSG_USERAUTH_REQUEST for publickey");
                buffer = this.session.createBuffer((byte)50);
                int pos1 = buffer.wpos() - 1;
                buffer.putString(this.session.getUsername());
                buffer.putString(this.service);
                buffer.putString("publickey");
                buffer.putByte((byte)1);
                buffer.putString(this.key.getPublic() instanceof RSAPublicKey ? "ssh-rsa" : "ssh-dss");
                int pos2 = buffer.wpos();
                buffer.putPublicKey(this.key.getPublic());
                Signature verif = (Signature)NamedFactory.Utils.create(this.session.getFactoryManager().getSignatureFactories(), this.key.getPublic() instanceof RSAPublicKey ? "ssh-rsa" : "ssh-dss");
                verif.init(this.key.getPublic(), this.key.getPrivate());
                Buffer bs = new Buffer();
                bs.putString(this.session.getKex().getH());
                bs.putByte((byte)50);
                bs.putString(this.session.getUsername());
                bs.putString(this.service);
                bs.putString("publickey");
                bs.putByte((byte)1);
                bs.putString(this.key.getPublic() instanceof RSAPublicKey ? "ssh-rsa" : "ssh-dss");
                bs.putPublicKey(this.key.getPublic());
                verif.update(bs.array(), bs.rpos(), bs.available());
                bs = new Buffer();
                bs.putString(this.key.getPublic() instanceof RSAPublicKey ? "ssh-rsa" : "ssh-dss");
                bs.putBytes(verif.sign());
                buffer.putBytes(bs.array(), bs.rpos(), bs.available());
                this.session.writePacket(buffer);
                return UserAuth.Result.Continued;
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw (IOException)new IOException("Error performing public key authentication").initCause(e);
            }
        }
        byte cmd = buffer.getByte();
        if (cmd == 52) {
            this.log.debug("Received SSH_MSG_USERAUTH_SUCCESS");
            return UserAuth.Result.Success;
        }
        if (cmd == 51) {
            this.log.debug("Received SSH_MSG_USERAUTH_FAILURE");
            return UserAuth.Result.Failure;
        }
        this.log.debug("Received unknown packet {}", cmd);
        return UserAuth.Result.Continued;
    }
}

