/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.channel;

import java.io.IOException;
import org.apache.sshd.common.channel.AbstractChannel;
import org.apache.sshd.common.channel.WindowClosedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Window {
    private static final Logger log = LoggerFactory.getLogger(Window.class);
    private final AbstractChannel channel;
    private final Object lock;
    private final String name;
    private int size;
    private int maxSize;
    private int packetSize;
    private boolean waiting;
    private boolean closed;

    public Window(AbstractChannel channel, Object lock, boolean client, boolean local) {
        this.channel = channel;
        this.lock = lock != null ? lock : this;
        this.name = (client ? "client" : "server") + " " + (local ? "local " : "remote") + " window";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() {
        Object object = this.lock;
        synchronized (object) {
            return this.size;
        }
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int getPacketSize() {
        return this.packetSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(int size, int packetSize) {
        Object object = this.lock;
        synchronized (object) {
            this.size = size;
            this.maxSize = size;
            this.packetSize = packetSize;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expand(int window) {
        Object object = this.lock;
        synchronized (object) {
            this.size += window;
            if (log.isDebugEnabled()) {
                log.debug("Increase " + this.name + " by " + window + " up to " + this.size);
            }
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consume(int len) {
        Object object = this.lock;
        synchronized (object) {
            this.size -= len;
            if (log.isTraceEnabled()) {
                log.trace("Consume " + this.name + " by " + len + " down to " + this.size);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consumeAndCheck(int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.size -= len;
            if (log.isTraceEnabled()) {
                log.trace("Consume " + this.name + " by " + len + " down to " + this.size);
            }
            this.check(this.maxSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check(int maxFree) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.size < maxFree / 2) {
                if (log.isDebugEnabled()) {
                    log.debug("Increase " + this.name + " by " + (maxFree - this.size) + " up to " + maxFree);
                }
                this.channel.sendWindowAdjust(maxFree - this.size);
                this.size = maxFree;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitAndConsume(int len) throws InterruptedException, WindowClosedException {
        Object object = this.lock;
        synchronized (object) {
            while (this.size < len && !this.closed) {
                log.debug("Waiting for {} bytes on {}", len, (Object)this.name);
                this.waiting = true;
                this.lock.wait();
            }
            if (this.waiting) {
                log.debug("Space available for {}", (Object)this.name);
                this.waiting = false;
            }
            if (this.closed) {
                throw new WindowClosedException();
            }
            this.size -= len;
            if (log.isTraceEnabled()) {
                log.trace("Consume " + this.name + " by " + len + " down to " + this.size);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int waitForSpace() throws InterruptedException, WindowClosedException {
        Object object = this.lock;
        synchronized (object) {
            while (this.size == 0 && !this.closed) {
                log.debug("Waiting for some space on {}", (Object)this.name);
                this.waiting = true;
                this.lock.wait();
            }
            if (this.waiting) {
                log.debug("Space available for {}", (Object)this.name);
                this.waiting = false;
            }
            if (this.closed) {
                throw new WindowClosedException();
            }
            return this.size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyClosed() {
        Object object = this.lock;
        synchronized (object) {
            this.closed = true;
            if (this.waiting) {
                this.lock.notifyAll();
            }
        }
    }
}

