/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.forward;

import java.io.IOException;
import java.io.OutputStream;
import java.net.ConnectException;
import org.apache.sshd.client.future.DefaultOpenFuture;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.common.Channel;
import org.apache.sshd.common.ForwardingFilter;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.SshdSocketAddress;
import org.apache.sshd.common.channel.ChannelOutputStream;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.io.IoConnectFuture;
import org.apache.sshd.common.io.IoConnector;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.util.Buffer;
import org.apache.sshd.common.util.Readable;
import org.apache.sshd.server.channel.AbstractServerChannel;
import org.apache.sshd.server.channel.OpenChannelException;

public class TcpipServerChannel
extends AbstractServerChannel {
    private final Type type;
    private IoConnector connector;
    private IoSession ioSession;
    private OutputStream out;

    public TcpipServerChannel(Type type) {
        this.type = type;
    }

    protected OpenFuture doInit(Buffer buffer) {
        final DefaultOpenFuture f = new DefaultOpenFuture(this);
        String hostToConnect = buffer.getString();
        int portToConnect = buffer.getInt();
        String originatorIpAddress = buffer.getString();
        int originatorPort = buffer.getInt();
        this.log.info("Receiving request for direct tcpip: hostToConnect={}, portToConnect={}, originatorIpAddress={}, originatorPort={}", new Object[]{hostToConnect, portToConnect, originatorIpAddress, originatorPort});
        SshdSocketAddress address = null;
        switch (this.type) {
            case Direct: {
                address = new SshdSocketAddress(hostToConnect, portToConnect);
                break;
            }
            case Forwarded: {
                address = this.service.getTcpipForwarder().getForwardedPort(portToConnect);
            }
        }
        ForwardingFilter filter = this.getSession().getFactoryManager().getTcpipForwardingFilter();
        if (address == null || filter == null || !filter.canConnect(address, this.getSession())) {
            super.close(true);
            f.setException(new OpenChannelException(1, "Connection denied"));
            return f;
        }
        this.out = new ChannelOutputStream(this, this.remoteWindow, this.log, 94);
        IoHandler handler = new IoHandler(){

            public void messageReceived(IoSession session, Readable message) throws Exception {
                if (TcpipServerChannel.this.state.get() != 0) {
                    TcpipServerChannel.this.log.debug("Ignoring write to channel {} in CLOSING state", TcpipServerChannel.this.id);
                } else {
                    Buffer buffer = new Buffer();
                    buffer.putBuffer(message);
                    TcpipServerChannel.this.out.write(buffer.array(), buffer.rpos(), buffer.available());
                    TcpipServerChannel.this.out.flush();
                }
            }

            public void sessionCreated(IoSession session) throws Exception {
            }

            public void sessionClosed(IoSession session) throws Exception {
                TcpipServerChannel.this.close(false);
            }

            public void exceptionCaught(IoSession ioSession, Throwable cause) throws Exception {
                TcpipServerChannel.this.close(true);
            }
        };
        this.connector = this.getSession().getFactoryManager().getIoServiceFactory().createConnector(handler);
        IoConnectFuture future = this.connector.connect(address.toInetSocketAddress());
        future.addListener(new SshFutureListener<IoConnectFuture>(){

            @Override
            public void operationComplete(IoConnectFuture future) {
                if (future.isConnected()) {
                    TcpipServerChannel.this.ioSession = future.getSession();
                    f.setOpened();
                } else if (future.getException() != null) {
                    TcpipServerChannel.this.closeImmediately0();
                    if (future.getException() instanceof ConnectException) {
                        f.setException(new OpenChannelException(2, future.getException().getMessage(), future.getException()));
                    } else {
                        f.setException(future.getException());
                    }
                }
            }
        });
        return f;
    }

    private void closeImmediately0() {
        super.close(true);
        new Thread("TcpIpServerChannel-ConnectorCleanup"){

            public void run() {
                TcpipServerChannel.this.connector.dispose();
            }
        }.start();
    }

    public CloseFuture close(boolean immediately) {
        return super.close(immediately).addListener(new SshFutureListener<CloseFuture>(){

            @Override
            public void operationComplete(CloseFuture sshFuture) {
                TcpipServerChannel.this.closeImmediately0();
            }
        });
    }

    protected void doWriteData(byte[] data, int off, int len) throws IOException {
        Buffer buf = new Buffer(data, off, len);
        buf = new Buffer(buf.getCompactData());
        this.ioSession.write(buf);
    }

    protected void doWriteExtendedData(byte[] data, int off, int len) throws IOException {
        throw new UnsupportedOperationException((Object)((Object)this.type) + "Tcpip channel does not support extended data");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Type {
        Direct,
        Forwarded;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ForwardedTcpipFactory
    implements NamedFactory<Channel> {
        @Override
        public String getName() {
            return "forwarded-tcpip";
        }

        @Override
        public Channel create() {
            return new TcpipServerChannel(Type.Forwarded);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DirectTcpipFactory
    implements NamedFactory<Channel> {
        @Override
        public String getName() {
            return "direct-tcpip";
        }

        @Override
        public Channel create() {
            return new TcpipServerChannel(Type.Direct);
        }
    }
}

