/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.session;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.sshd.agent.common.AgentForwardSupport;
import org.apache.sshd.client.channel.AbstractClientChannel;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.common.Channel;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.RequestHandler;
import org.apache.sshd.common.Session;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.TcpipForwarder;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.session.AbstractSession;
import org.apache.sshd.common.session.ConnectionService;
import org.apache.sshd.common.util.Buffer;
import org.apache.sshd.common.util.CloseableUtils;
import org.apache.sshd.server.channel.OpenChannelException;
import org.apache.sshd.server.x11.X11ForwardSupport;

public abstract class AbstractConnectionService
extends CloseableUtils.AbstractInnerCloseable
implements ConnectionService {
    protected final Map<Integer, Channel> channels = new ConcurrentHashMap<Integer, Channel>();
    protected final AtomicInteger nextChannelId = new AtomicInteger(0);
    protected final Session session;
    protected final TcpipForwarder tcpipForwarder;
    protected final AgentForwardSupport agentForward;
    protected final X11ForwardSupport x11Forward;
    protected boolean allowMoreSessions = true;

    protected AbstractConnectionService(Session session) {
        this.session = session;
        this.agentForward = new AgentForwardSupport(this);
        this.x11Forward = new X11ForwardSupport(this);
        this.tcpipForwarder = session.getFactoryManager().getTcpipForwarderFactory().create(this);
    }

    public AbstractSession getSession() {
        return (AbstractSession)this.session;
    }

    public void start() {
    }

    public TcpipForwarder getTcpipForwarder() {
        return this.tcpipForwarder;
    }

    protected Closeable getInnerCloseable() {
        return CloseableUtils.sequential(this.tcpipForwarder, this.agentForward, this.x11Forward, CloseableUtils.parallel(this.channels.values()));
    }

    protected int getNextChannelId() {
        return this.nextChannelId.getAndIncrement();
    }

    public int registerChannel(Channel channel) throws IOException {
        if (this.state.get() != 0) {
            throw new IllegalStateException("Session is being closed");
        }
        int channelId = this.getNextChannelId();
        channel.init(this, this.session, channelId);
        this.channels.put(channelId, channel);
        return channelId;
    }

    public void unregisterChannel(Channel channel) {
        this.channels.remove(channel.getId());
    }

    public void process(byte cmd, Buffer buffer) throws Exception {
        switch (cmd) {
            case 90: {
                this.channelOpen(buffer);
                break;
            }
            case 91: {
                this.channelOpenConfirmation(buffer);
                break;
            }
            case 92: {
                this.channelOpenFailure(buffer);
                break;
            }
            case 98: {
                this.channelRequest(buffer);
                break;
            }
            case 94: {
                this.channelData(buffer);
                break;
            }
            case 95: {
                this.channelExtendedData(buffer);
                break;
            }
            case 100: {
                this.channelFailure(buffer);
                break;
            }
            case 93: {
                this.channelWindowAdjust(buffer);
                break;
            }
            case 96: {
                this.channelEof(buffer);
                break;
            }
            case 97: {
                this.channelClose(buffer);
                break;
            }
            case 80: {
                this.globalRequest(buffer);
                break;
            }
            case 81: {
                this.requestSuccess(buffer);
                break;
            }
            case 82: {
                this.requestFailure(buffer);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported command: " + cmd);
            }
        }
    }

    public void setAllowMoreSessions(boolean allow) {
        this.allowMoreSessions = allow;
    }

    public void channelOpenConfirmation(Buffer buffer) throws IOException {
        Channel channel = this.getChannel(buffer);
        this.log.debug("Received SSH_MSG_CHANNEL_OPEN_CONFIRMATION on channel {}", channel.getId());
        int recipient = buffer.getInt();
        int rwsize = buffer.getInt();
        int rmpsize = buffer.getInt();
        channel.handleOpenSuccess(recipient, rwsize, rmpsize, buffer);
    }

    public void channelOpenFailure(Buffer buffer) throws IOException {
        AbstractClientChannel channel = (AbstractClientChannel)this.getChannel(buffer);
        this.log.debug("Received SSH_MSG_CHANNEL_OPEN_FAILURE on channel {}", channel.getId());
        this.channels.remove(channel.getId());
        channel.handleOpenFailure(buffer);
    }

    public void channelData(Buffer buffer) throws IOException {
        Channel channel = this.getChannel(buffer);
        channel.handleData(buffer);
    }

    public void channelExtendedData(Buffer buffer) throws IOException {
        Channel channel = this.getChannel(buffer);
        channel.handleExtendedData(buffer);
    }

    public void channelWindowAdjust(Buffer buffer) throws IOException {
        try {
            Channel channel = this.getChannel(buffer);
            channel.handleWindowAdjust(buffer);
        }
        catch (SshException e) {
            this.log.info(e.getMessage());
        }
    }

    public void channelEof(Buffer buffer) throws IOException {
        Channel channel = this.getChannel(buffer);
        channel.handleEof();
    }

    public void channelClose(Buffer buffer) throws IOException {
        Channel channel = this.getChannel(buffer);
        channel.handleClose();
        this.unregisterChannel(channel);
    }

    public void channelRequest(Buffer buffer) throws IOException {
        Channel channel = this.getChannel(buffer);
        channel.handleRequest(buffer);
    }

    public void channelFailure(Buffer buffer) throws IOException {
        Channel channel = this.getChannel(buffer);
        channel.handleFailure();
    }

    protected Channel getChannel(Buffer buffer) throws IOException {
        int recipient = buffer.getInt();
        Channel channel = this.channels.get(recipient);
        if (channel == null) {
            buffer.rpos(buffer.rpos() - 5);
            byte cmd = buffer.getByte();
            throw new SshException("Received " + cmd + " on unknown channel " + recipient);
        }
        return channel;
    }

    protected void channelOpen(Buffer buffer) throws Exception {
        String type = buffer.getString();
        final int id = buffer.getInt();
        int rwsize = buffer.getInt();
        int rmpsize = buffer.getInt();
        this.log.debug("Received SSH_MSG_CHANNEL_OPEN {}", (Object)type);
        if (this.state.get() != 0) {
            Buffer buf = this.session.createBuffer((byte)92);
            buf.putInt(id);
            buf.putInt(2L);
            buf.putString("SSH server is shutting down: " + type);
            buf.putString("");
            this.session.writePacket(buf);
            return;
        }
        if (!this.allowMoreSessions) {
            Buffer buf = this.session.createBuffer((byte)92);
            buf.putInt(id);
            buf.putInt(2L);
            buf.putString("additional sessions disabled");
            buf.putString("");
            this.session.writePacket(buf);
            return;
        }
        final Channel channel = (Channel)NamedFactory.Utils.create(this.session.getFactoryManager().getChannelFactories(), type);
        if (channel == null) {
            Buffer buf = this.session.createBuffer((byte)92);
            buf.putInt(id);
            buf.putInt(3L);
            buf.putString("Unsupported channel type: " + type);
            buf.putString("");
            this.session.writePacket(buf);
            return;
        }
        final int channelId = this.registerChannel(channel);
        channel.open(id, rwsize, rmpsize, buffer).addListener(new SshFutureListener<OpenFuture>(){

            @Override
            public void operationComplete(OpenFuture future) {
                try {
                    if (future.isOpened()) {
                        Buffer buf = AbstractConnectionService.this.session.createBuffer((byte)91);
                        buf.putInt(id);
                        buf.putInt(channelId);
                        buf.putInt(channel.getLocalWindow().getSize());
                        buf.putInt(channel.getLocalWindow().getPacketSize());
                        AbstractConnectionService.this.session.writePacket(buf);
                    } else {
                        Throwable exception = future.getException();
                        if (exception != null) {
                            Buffer buf = AbstractConnectionService.this.session.createBuffer((byte)92);
                            buf.putInt(id);
                            if (exception instanceof OpenChannelException) {
                                buf.putInt(((OpenChannelException)exception).getReasonCode());
                                buf.putString(exception.getMessage());
                            } else {
                                buf.putInt(0L);
                                buf.putString("Error opening channel: " + exception.getMessage());
                            }
                            buf.putString("");
                            AbstractConnectionService.this.session.writePacket(buf);
                        }
                    }
                }
                catch (IOException e) {
                    AbstractConnectionService.this.session.exceptionCaught(e);
                }
            }
        });
    }

    protected void globalRequest(Buffer buffer) throws Exception {
        String req = buffer.getString();
        boolean wantReply = buffer.getBoolean();
        this.log.debug("Received SSH_MSG_GLOBAL_REQUEST {}", (Object)req);
        List<RequestHandler<ConnectionService>> handlers = this.session.getFactoryManager().getGlobalRequestHandlers();
        if (handlers != null) {
            for (RequestHandler<ConnectionService> handler : handlers) {
                RequestHandler.Result result;
                try {
                    result = handler.process(this, req, wantReply, buffer);
                }
                catch (Exception e) {
                    this.log.warn("Error processing global request " + req, e);
                    result = RequestHandler.Result.ReplyFailure;
                }
                switch (result) {
                    case Replied: {
                        return;
                    }
                    case ReplySuccess: {
                        if (wantReply) {
                            buffer = this.session.createBuffer((byte)81);
                            this.session.writePacket(buffer);
                        }
                        return;
                    }
                    case ReplyFailure: {
                        if (wantReply) {
                            buffer = this.session.createBuffer((byte)82);
                            this.session.writePacket(buffer);
                        }
                        return;
                    }
                }
            }
        }
        this.log.warn("Unknown global request: {}", (Object)req);
        if (wantReply) {
            buffer = this.session.createBuffer((byte)82);
            this.session.writePacket(buffer);
        }
    }

    protected void requestSuccess(Buffer buffer) throws Exception {
        ((AbstractSession)this.session).requestSuccess(buffer);
    }

    protected void requestFailure(Buffer buffer) throws Exception {
        ((AbstractSession)this.session).requestFailure(buffer);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

