/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.session;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.sshd.common.Session;
import org.apache.sshd.common.SessionListener;
import org.apache.sshd.server.session.ServerSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerSessionTimeoutListener
implements SessionListener,
Runnable {
    private final Logger log = LoggerFactory.getLogger(ServerSessionTimeoutListener.class);
    private final Set<ServerSession> sessions = new CopyOnWriteArraySet<ServerSession>();

    public void sessionCreated(Session session) {
        if (session instanceof ServerSession) {
            this.sessions.add((ServerSession)session);
        }
    }

    public void sessionEvent(Session sesssion, SessionListener.Event event) {
    }

    public void sessionClosed(Session s) {
        this.sessions.remove(s);
    }

    public void run() {
        for (ServerSession session : this.sessions) {
            try {
                session.checkForTimeouts();
            }
            catch (Exception e) {
                this.log.warn("An error occurred while checking session timeouts", e);
            }
        }
    }
}

