/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.http.server;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jgit.http.server.HttpServerText;
import org.eclipse.jgit.http.server.ServletUtils;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.transport.BaseReceivePack;
import org.eclipse.jgit.transport.PacketLineIn;
import org.eclipse.jgit.transport.PacketLineOut;
import org.eclipse.jgit.transport.ReceivePack;
import org.eclipse.jgit.transport.RequestNotYetReadException;
import org.eclipse.jgit.transport.SideBandOutputStream;
import org.eclipse.jgit.transport.UploadPack;

public class GitSmartHttpTools {
    private static final String INFO_REFS = "info/refs";
    public static final String UPLOAD_PACK = "git-upload-pack";
    public static final String RECEIVE_PACK = "git-receive-pack";
    public static final String UPLOAD_PACK_REQUEST_TYPE = "application/x-git-upload-pack-request";
    public static final String UPLOAD_PACK_RESULT_TYPE = "application/x-git-upload-pack-result";
    public static final String RECEIVE_PACK_REQUEST_TYPE = "application/x-git-receive-pack-request";
    public static final String RECEIVE_PACK_RESULT_TYPE = "application/x-git-receive-pack-result";
    public static final List<String> VALID_SERVICES = Collections.unmodifiableList(Arrays.asList("git-upload-pack", "git-receive-pack"));
    private static final String INFO_REFS_PATH = "/info/refs";
    private static final String UPLOAD_PACK_PATH = "/git-upload-pack";
    private static final String RECEIVE_PACK_PATH = "/git-receive-pack";
    private static final List<String> SERVICE_SUFFIXES = Collections.unmodifiableList(Arrays.asList("/info/refs", "/git-upload-pack", "/git-receive-pack"));

    public static boolean isGitClient(HttpServletRequest req) {
        return GitSmartHttpTools.isInfoRefs(req) || GitSmartHttpTools.isUploadPack(req) || GitSmartHttpTools.isReceivePack(req);
    }

    public static void sendError(HttpServletRequest req, HttpServletResponse res, int httpStatus) throws IOException {
        GitSmartHttpTools.sendError(req, res, httpStatus, null);
    }

    public static void sendError(HttpServletRequest req, HttpServletResponse res, int httpStatus, String textForGit) throws IOException {
        if (textForGit == null || textForGit.length() == 0) {
            switch (httpStatus) {
                case 403: {
                    textForGit = HttpServerText.get().repositoryAccessForbidden;
                    break;
                }
                case 404: {
                    textForGit = HttpServerText.get().repositoryNotFound;
                    break;
                }
                case 500: {
                    textForGit = HttpServerText.get().internalServerError;
                    break;
                }
                default: {
                    textForGit = "HTTP " + httpStatus;
                }
            }
        }
        if (GitSmartHttpTools.isInfoRefs(req)) {
            GitSmartHttpTools.sendInfoRefsError(req, res, textForGit);
        } else if (GitSmartHttpTools.isUploadPack(req)) {
            GitSmartHttpTools.sendUploadPackError(req, res, textForGit);
        } else if (GitSmartHttpTools.isReceivePack(req)) {
            GitSmartHttpTools.sendReceivePackError(req, res, textForGit);
        } else {
            if (httpStatus < 400) {
                ServletUtils.consumeRequestBody(req);
            }
            res.sendError(httpStatus);
        }
    }

    private static void sendInfoRefsError(HttpServletRequest req, HttpServletResponse res, String textForGit) throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream(128);
        PacketLineOut pck = new PacketLineOut(buf);
        String svc = req.getParameter("service");
        pck.writeString("# service=" + svc + "\n");
        pck.end();
        pck.writeString("ERR " + textForGit);
        GitSmartHttpTools.send(req, res, GitSmartHttpTools.infoRefsResultType(svc), buf.toByteArray());
    }

    private static void sendUploadPackError(HttpServletRequest req, HttpServletResponse res, String textForGit) throws IOException {
        boolean sideband;
        ByteArrayOutputStream buf = new ByteArrayOutputStream(128);
        PacketLineOut pckOut = new PacketLineOut(buf);
        UploadPack up = (UploadPack)req.getAttribute("org.eclipse.jgit.transport.UploadPackOrReceivePack");
        if (up != null) {
            try {
                sideband = up.isSideBand();
            }
            catch (RequestNotYetReadException e) {
                sideband = GitSmartHttpTools.isUploadPackSideBand(req);
            }
        } else {
            sideband = GitSmartHttpTools.isUploadPackSideBand(req);
        }
        if (sideband) {
            GitSmartHttpTools.writeSideBand(buf, textForGit);
        } else {
            GitSmartHttpTools.writePacket(pckOut, textForGit);
        }
        GitSmartHttpTools.send(req, res, UPLOAD_PACK_RESULT_TYPE, buf.toByteArray());
    }

    private static boolean isUploadPackSideBand(HttpServletRequest req) {
        try {
            String line = new PacketLineIn(req.getInputStream()).readString();
            UploadPack.FirstLine parsed = new UploadPack.FirstLine(line);
            return parsed.getOptions().contains("side-band") || parsed.getOptions().contains("side-band-64k");
        }
        catch (IOException e) {
            return false;
        }
    }

    private static void sendReceivePackError(HttpServletRequest req, HttpServletResponse res, String textForGit) throws IOException {
        boolean sideband;
        ByteArrayOutputStream buf = new ByteArrayOutputStream(128);
        PacketLineOut pckOut = new PacketLineOut(buf);
        ReceivePack rp = (ReceivePack)req.getAttribute("org.eclipse.jgit.transport.UploadPackOrReceivePack");
        if (rp != null) {
            try {
                sideband = rp.isSideBand();
            }
            catch (RequestNotYetReadException e) {
                sideband = GitSmartHttpTools.isReceivePackSideBand(req);
            }
        } else {
            sideband = GitSmartHttpTools.isReceivePackSideBand(req);
        }
        if (sideband) {
            GitSmartHttpTools.writeSideBand(buf, textForGit);
        } else {
            GitSmartHttpTools.writePacket(pckOut, textForGit);
        }
        GitSmartHttpTools.send(req, res, RECEIVE_PACK_RESULT_TYPE, buf.toByteArray());
    }

    private static boolean isReceivePackSideBand(HttpServletRequest req) {
        try {
            String line = new PacketLineIn(req.getInputStream()).readString();
            BaseReceivePack.FirstLine parsed = new BaseReceivePack.FirstLine(line);
            return parsed.getCapabilities().contains("side-band-64k");
        }
        catch (IOException e) {
            return false;
        }
    }

    private static void writeSideBand(OutputStream out, String textForGit) throws IOException {
        SideBandOutputStream msg = new SideBandOutputStream(3, 1000, out);
        msg.write(Constants.encode("error: " + textForGit));
        ((OutputStream)msg).flush();
    }

    private static void writePacket(PacketLineOut pckOut, String textForGit) throws IOException {
        pckOut.writeString("error: " + textForGit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void send(HttpServletRequest req, HttpServletResponse res, String type, byte[] buf) throws IOException {
        ServletUtils.consumeRequestBody(req);
        res.setStatus(200);
        res.setContentType(type);
        res.setContentLength(buf.length);
        ServletOutputStream os = res.getOutputStream();
        try {
            os.write(buf);
        }
        finally {
            os.close();
        }
    }

    public static String getResponseContentType(HttpServletRequest req) {
        if (GitSmartHttpTools.isInfoRefs(req)) {
            return GitSmartHttpTools.infoRefsResultType(req.getParameter("service"));
        }
        if (GitSmartHttpTools.isUploadPack(req)) {
            return UPLOAD_PACK_RESULT_TYPE;
        }
        if (GitSmartHttpTools.isReceivePack(req)) {
            return RECEIVE_PACK_RESULT_TYPE;
        }
        throw new IllegalArgumentException();
    }

    static String infoRefsResultType(String svc) {
        return "application/x-" + svc + "-advertisement";
    }

    public static String stripServiceSuffix(String path) {
        for (String suffix : SERVICE_SUFFIXES) {
            if (!path.endsWith(suffix)) continue;
            return path.substring(0, path.length() - suffix.length());
        }
        return path;
    }

    public static boolean isInfoRefs(HttpServletRequest req) {
        return req.getRequestURI().endsWith(INFO_REFS_PATH) && VALID_SERVICES.contains(req.getParameter("service"));
    }

    public static boolean isUploadPack(String pathOrUri) {
        return pathOrUri != null && pathOrUri.endsWith(UPLOAD_PACK_PATH);
    }

    public static boolean isUploadPack(HttpServletRequest req) {
        return GitSmartHttpTools.isUploadPack(req.getRequestURI()) && UPLOAD_PACK_REQUEST_TYPE.equals(req.getContentType());
    }

    public static boolean isReceivePack(HttpServletRequest req) {
        String uri = req.getRequestURI();
        return uri != null && uri.endsWith(RECEIVE_PACK_PATH) && RECEIVE_PACK_REQUEST_TYPE.equals(req.getContentType());
    }

    private GitSmartHttpTools() {
    }
}

