/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.extensions.registration;

import com.google.gerrit.extensions.registration.DynamicItemProvider;
import com.google.gerrit.extensions.registration.RegistrationHandle;
import com.google.gerrit.extensions.registration.ReloadableRegistrationHandle;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.binder.LinkedBindingBuilder;
import com.google.inject.util.Providers;
import com.google.inject.util.Types;
import java.lang.reflect.Type;
import java.util.concurrent.atomic.AtomicReference;

public class DynamicItem<T> {
    private final Key<DynamicItem<T>> key;
    private final AtomicReference<NamedProvider<T>> ref;

    public static <T> void itemOf(Binder binder, Class<T> member) {
        DynamicItem.itemOf(binder, TypeLiteral.get(member));
    }

    public static <T> void itemOf(Binder binder, TypeLiteral<T> member) {
        Key key = Key.get(Types.newParameterizedType(DynamicItem.class, new Type[]{member.getType()}));
        binder.bind(key).toProvider(new DynamicItemProvider<T>(member, key)).in(Scopes.SINGLETON);
    }

    public static <T> LinkedBindingBuilder<T> bind(Binder binder, Class<T> type) {
        return DynamicItem.bind(binder, TypeLiteral.get(type));
    }

    public static <T> LinkedBindingBuilder<T> bind(Binder binder, TypeLiteral<T> type) {
        return binder.bind(type);
    }

    DynamicItem(Key<DynamicItem<T>> key, Provider<T> provider, String pluginName) {
        NamedProvider<T> in = null;
        if (provider != null) {
            in = new NamedProvider<T>(provider, pluginName);
        }
        this.key = key;
        this.ref = new AtomicReference<NamedProvider<T>>(in);
    }

    public T get() {
        NamedProvider<T> item = this.ref.get();
        return item != null ? (T)item.impl.get() : null;
    }

    public RegistrationHandle set(T item, String pluginName) {
        return this.set(Providers.of(item), pluginName);
    }

    public RegistrationHandle set(Provider<T> impl, String pluginName) {
        final NamedProvider<T> item = new NamedProvider<T>(impl, pluginName);
        while (!this.ref.compareAndSet(null, item)) {
            NamedProvider<T> old = this.ref.get();
            if (old == null) continue;
            throw new ProvisionException(String.format("%s already provided by %s, ignoring plugin %s", this.key.getTypeLiteral(), old.pluginName, pluginName));
        }
        return new RegistrationHandle(){

            @Override
            public void remove() {
                DynamicItem.this.ref.compareAndSet(item, null);
            }
        };
    }

    public ReloadableRegistrationHandle<T> set(Key<T> key, Provider<T> impl, String pluginName) {
        NamedProvider<T> item = new NamedProvider<T>(impl, pluginName);
        while (!this.ref.compareAndSet(null, item)) {
            NamedProvider<T> old = this.ref.get();
            if (old == null) continue;
            throw new ProvisionException(String.format("%s already provided by %s, ignoring plugin %s", this.key.getTypeLiteral(), old.pluginName, pluginName));
        }
        return new ReloadableHandle(key, item);
    }

    private class ReloadableHandle
    implements ReloadableRegistrationHandle<T> {
        private final Key<T> key;
        private final NamedProvider<T> item;

        ReloadableHandle(Key<T> key, NamedProvider<T> item) {
            this.key = key;
            this.item = item;
        }

        @Override
        public Key<T> getKey() {
            return this.key;
        }

        @Override
        public void remove() {
            DynamicItem.this.ref.compareAndSet(this.item, null);
        }

        @Override
        public ReloadableHandle replace(Key<T> newKey, Provider<T> newItem) {
            NamedProvider n = new NamedProvider(newItem, this.item.pluginName);
            if (DynamicItem.this.ref.compareAndSet(this.item, n)) {
                return new ReloadableHandle(newKey, n);
            }
            return null;
        }
    }

    static class NamedProvider<T> {
        final Provider<T> impl;
        final String pluginName;

        NamedProvider(Provider<T> provider, String pluginName) {
            this.impl = provider;
            this.pluginName = pluginName;
        }
    }
}

