/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd.auth.container;

import com.google.gerrit.common.Nullable;
import com.google.gerrit.server.config.CanonicalWebUrl;
import com.google.gwtexpui.server.CacheHeaders;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Singleton
public class HttpsClientSslCertLoginServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private final Provider<String> urlProvider;

    @Inject
    public HttpsClientSslCertLoginServlet(@CanonicalWebUrl @Nullable Provider<String> urlProvider) {
        this.urlProvider = urlProvider;
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse rsp) throws IOException {
        StringBuilder rdr = new StringBuilder();
        rdr.append(this.urlProvider.get());
        rdr.append('#');
        rdr.append(this.getToken(req));
        CacheHeaders.setNotCacheable(rsp);
        rsp.sendRedirect(rdr.toString());
    }

    private String getToken(HttpServletRequest req) {
        String token = req.getPathInfo();
        if (token == null || token.isEmpty()) {
            token = "/";
        }
        return token;
    }
}

